	
<h3>
	<font color="red">Lasso Summit - October 2002</font>
	<br><font color="green">Advanced Developer Techniques</font>
	<br><font color="blue">Compound Expressions Examples</font>
	<br>By Fletcher Sandbeck
</h3>

<p>This file demonstrates several characteristics of compound expressions.  See the
accompanying paper for full documentation of these examples.

<p><font color="red"><b>Inline Compound Expression</b></font>

<p>This code creates an inline compound expression and evaluates it immediately.

<pre>[NoProcess]
[var: 'condition' = 'Howdy Partner']
[var: 'test' = { 
	if: ($condition == null); 
		return: ''; 
	/if; 
	return: $condition; 
}]
[/NoProcess]</pre>

[var: 'condition' = 'Howdy Partner']
[var: 'test' = { 
	if: ($condition == null); 
		return: ''; 
	/if; 
	return: $condition; 
}]
<p>>>>> [output: $test->eval]



<p><font color="green"><b>Evaluate Compound Expression</b></font>

<p>This code creates a compound expression and stores it in a variable, then evaluates it
from the variable.

<pre>[NoProcess]
[var: 'condition' = 'Howdy Partner']
[var: 'myTest' = { 
	if: ($condition == null); 
		return: ''; 
	/if; 
	return: $condition; 
}]
[var: 'test' = $myTest->Eval]
[/NoProcess]</pre>

[var: 'condition' = 'Howdy Partner']
[var: 'myTest' = { 
	if: ($condition == null); 
		return: ''; 
	/if; 
	return: $condition; 
}]
[var: 'test' = $myTest->Eval]
<p>>>>> [output: $test]



<p><font color="blue"><b>Run Compound Expression</b></font>

<p>This code creates a compound expression and calls it with a parameter like a tag.

<pre>[NoProcess]
[var: 'condition' = 'Howdy Partner']
[var: 'myTag' = { 
		if: (params->(get:1) == null); 
			return: ''; 
		/if; 
		return: params->(get:1); 
}]
[var: 'test' = $myTag->(Run: -Params=$condition)]
[/NoProcess]</pre>

[var: 'condition' = 'Howdy Partner']
[var: 'myTag' = { 
		if: (params->(get:1) == null); 
			return: ''; 
		/if; 
		return: params->(get:1); 
}]
[var: 'test' = $myTag->(Run: -Params=$condition)]
<p>>>>> [output: $test]



<p><font color="red"><b>Store Compound Expression</b></font>

<p>This code creates a compound expression and stores it in the tags map so it
can be called as a regular tag.

<pre>[NoProcess]
[var: 'condition' = 'Howdy Partner']
[var: 'myTag' = { 
		if: (params->(get:1) == null); 
			return: ''; 
		/if; 
		return: params->(get:1); 
}]
[Tags->(Insert: 'myTag', $myTag)]
[var: 'test' = (myTag: $condition)]
[/NoProcess]</pre>

[var: 'condition' = 'Howdy Partner']
[var: 'myTag' = { 
		if: (params->(get:1) == null); 
			return: ''; 
		/if; 
		return: params->(get:1); 
}]
[tags->(Insert: 'myTag'=$myTag)]
[var: 'test' = (myTag: $condition)]
<p>>>>> [output: $test]



<p><font color="green"><b>Process Array</b></font>

<p>This code creates a custom tag that allows a compound expression to be applied to each
element of an array.  The custom tag is used to square each element of a simple array.

<pre>[NoProcess]
[Define_Tag: 'exArray', -Required='myArray', -Required='myTag']
	[iterate: #myArray, (local: 'myItem')]
		[#myItem = #myTag->(Run: -Params=#myItem)]
	[/iterate]
[/Define_Tag]
[var: 'myArray' = (array: 1, 2, 3, 4, 5)]
[exArray: $myArray, { return: (params->(get: 1) * params->(get:1)) }]
[/NoProcess]</pre>

[Define_Tag: 'exArray', -Required='myArray', -Required='myTag']
	[iterate: #myArray, (local: 'myItem')]
		[#myItem = #myTag->(Run: -Params=#myItem)]
	[/iterate]
[/Define_Tag]
[var: 'myArray' = (array: 1, 2, 3, 4, 5)]
[exArray: $myArray, { return: (params->(get: 1) * params->(get:1)) }]
<p>>>>> [output: $myArray]

<p>&nbsp;