<?LassoScript
	
	if: ((action_param: 'reset') != '');
		globals->(remove: 'ex_Cache_Storage');
	/if;

	// Description:
	//
	// [exCache] ... [/exCache] is a container tag which caches the contents
	// of the container in a global variable.
	//
	// Author:
	//
	// Fletcher Sandbeck <fletcher@blueworld.com>
	// Example for the Lasso Summit - October 2002
	//
	// Parameters:
	//
	// -Name is the name of the cache.  Each server can name multiple items to cache.
	// -Expires specifies how many seconds must go by before old content is refreshed.
	// -Condition if true means the cached content should be refreshed immediately.
	// -Log if true will log a warning to the console every time this tag is called.
	//
	// Examples: 
	//
	// [exCache: -name='topten', -expires=600] [inline: ...] ... [/inline] [/exCache]
	// A top ten list can be displayed on your home page and refreshed every 10 minutes 
	// rather than performing a database request each time the front page is loaded.
	//
	// Warning:
	// 
	// The cache for exCache is shared among all the users of the machine.  It should not
	// be used to cache sensitive data on a shared machine.
	//

	define_tag: 'exCache', -container, -required='name', -optional='expires', -optional='condition', -optional='log';

		// Processing incoming parameters;
		if: !(local_defined: 'log');
			local: 'log' = false;
		/if;

		// Initialize the global cache storage
		if: !(global_defined: 'ex_Cache_Storage');
			global: 'ex_Cache_Storage' = (map);
		/if;
		local: 'storage' = @(global: 'ex_Cache_Storage');
		local: 'cache' = @#storage->(find: #name);

		// Check whether refresh is needed
		local: 'refresh' = false;
		if: (#cache == null) || (#cache->type != 'map');
			// Store the contents in the cache and return it
			local: 'cache' = (map);
			local: 'refresh' = true;
		else: (local_defined: 'expires') || (local_defined: 'condition');
			if: (local_defined: 'expires');
				local: 'exp' = (date_add: #cache->(find: 'date'), -second=#expires);
				local: 'dif' = (date_difference: (string:date), (string: #exp), -secondsbetween);
				if: ( #dif > 0);
					local: 'refresh' = true;
				else;
					local: 'refresh' = false;
				/if;
			/if;
			if: (local_defined: 'condition');
				if: (#condition == true);
					local: 'refresh' = true;
				else;
					local: 'refresh' = false;
				/if;
			/if;
		else;
			local: 'refresh' = true;
		/if;
		
		// Perform refresh if needed and return contents
		if: #refresh;
			local: 'contents' = (run_children);
			#cache->(insert: 'date' = (string:date));
			#cache->(insert: 'contents' = @#contents);
			#storage->(insert: #name = #cache);
			if: (#log == true);
				log_warning: 'Cache: Refreshing ' + #name + ' at ' + (string:date) + ' (' + (#contents->size) + ').';
			/if;
			return: #contents;
		else;
			if: (#log == true);
				log_warning: 'Cache: Fetching ' + #name + ' from ' + #cache->(find: 'date') + ' (' + (#cache->(find: 'contents')->size) + ').';
			/if;
			return: #cache->(find: 'contents');
		/if;
	/define_tag;
?>

<h3>
	<font color="red">Lasso Summit - October 2002</font>
	<br><font color="green">Advanced Developer Techniques</font>
	<br><font color="blue">exCache Example</font>
	<br>By Fletcher Sandbeck
</h3>

<p>This file demonstrates the exCache tags which allow a portion of a tag to be cached
in a global variable and retrieved.  Cached content is set with an expiration so that
once it times out new content can be generated.

<p>Use this link to <a href="[response_filepath]">Reload the Page</a>.
Use this link to <a href="[response_filepath]?reset=true">Reset the Cache</a>.

<p>
[exCache: -name='seconds', -expires=5, -log=true]
	<table border=1 cellspading=3 cellpadding=3>
		<tr>
			<td>
				<font color="red">This table refreshes every 5 seconds.
				<br>Last refreshed at [date]</font>
			</td>
		</tr>
	</table>
[/exCache]

<p>
[exCache: -name='minutes', -expires=30, -log=true]
	<table border=1 cellspading=3 cellpadding=3>
		<tr>
			<td>
				<font color="green">This table refreshes every 30 seconds.
				<br>Last refreshed at [date]</font>
			</td>
		</tr>
	</table>
[/exCache]

<p>
[exCache: -name='hours', -expires=60, -log=true]
	<table border=1 cellspading=3 cellpadding=3>
		<tr>
			<td>
				<font color="blue">This table refreshes every 60 seconds.
				<br>Last refreshed at [date]</font>
			</td>
		</tr>
	</table>
[/exCache]

[if: (global_defined: 'ex_cache_storage')]

<p>The cache storage variable is output here with information about what data has been cached.

<p><table border=1 cellspading=3 cellpadding=3>
[var: 'cache' = (global: 'ex_cache_storage')->(get:1)]
	<tr>
		<td><b>name</b></td>
[iterate: $cache->second, (var: 'item')]
		<td><b>[output: $item->first]</b></td>
[/iterate]
	</tr>
[iterate: (global: 'ex_cache_storage'), (var: 'cache')]
	<tr>
		<td>[output: $cache->first]</td>
[iterate: $cache->second, (var: 'item')]
		<td>[output: $item->second]</td>
[/iterate]
	</tr>
[/iterate]
</table>

[else]

<p>The cache storage variable does not contain any data!

[/if]

