<!--
	
	// Description:
	//
	// [exVector] is a data type that allows mathematical vectors to be manipulated using
	// standard built-in mathematical symbols such as + - * / %.
	//
	// Author:
	//
	// Fletcher Sandbeck <fletcher@blueworld.com>
	// Example for the Lasso Summit - October 2002
	//
	// Parameters:
	//
	// Requires one or more integer, decimal, or string values that will be the initial
	// value of the vector.
	//
	// Tags:
	//
	// Supports all array tags and symbol overloads for + - * / %, assignment variations,
	// conditional symbols, and the contains symbol >>.
	//
-->

[Define_type: 'exVector', 'array']
		
	[Define_Tag: '+', -Required='item']
		[local: 'result' = (exVector)]
		[if: (#item->type == self->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) + #item->(get: loop_count))]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) + #item)]
			[/loop]
		[/if]
		[return: #result]
	[/Define_Tag]
	
	[Define_Tag: '+=', -Required='item']
		[if: (#item->type == self->type)]
			[loop: self->size]
				[self->(get: loop_count) += #item->(get: loop_count)]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[self->(get: loop_count) += #item]
			[/loop]
		[/if]
	[/Define_Tag]

	[Define_Tag: '-', -Required='item']
		[local: 'result' = (exVector)]
		[if: (#item->type == self->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) - #item->(get: loop_count))]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) - #item)]
			[/loop]
		[/if]
		[return: #result]
	[/Define_Tag]
	
	[Define_Tag: '-=', -Required='item']
		[if: (#item->type == self->type)]
			[loop: self->size]
				[self->(get: loop_count) -= #item->(get: loop_count)]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[self->(get: loop_count) -= #item]
			[/loop]
		[/if]
	[/Define_Tag]

	[Define_Tag: '*', -Required='item']
		[local: 'result' = (exVector)]
		[if: (#item->type == self->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) * #item->(get: loop_count))]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) * #item)]
			[/loop]
		[/if]
		[return: #result]
	[/Define_Tag]
	
	[Define_Tag: '*=', -Required='item']
		[if: (#item->type == self->type)]
			[loop: self->size]
				[self->(get: loop_count) *= #item->(get: loop_count)]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[self->(get: loop_count) *= #item]
			[/loop]
		[/if]
	[/Define_Tag]

	[Define_Tag: '/', -Required='item']
		[local: 'result' = (exVector)]
		[if: (#item->type == self->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) / #item->(get: loop_count))]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) / #item)]
			[/loop]
		[/if]
		[return: #result]
	[/Define_Tag]
	
	[Define_Tag: '/=', -Required='item']
		[if: (#item->type == self->type)]
			[loop: self->size]
				[self->(get: loop_count) /= #item->(get: loop_count)]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[self->(get: loop_count) /= #item]
			[/loop]
		[/if]
	[/Define_Tag]

	[Define_Tag: '%', -Required='item']
		[local: 'result' = (exVector)]
		[if: (#item->type == self->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) % #item->(get: loop_count))]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[#result->(insert: self->(get: loop_count) % #item)]
			[/loop]
		[/if]
		[return: #result]
	[/Define_Tag]
	
	[Define_Tag: '%=', -Required='item']
		[if: (#item->type == self->type)]
			[loop: self->size]
				[self->(get: loop_count) %= #item->(get: loop_count)]
			[/loop]
		[else: ((array: 'string', 'integer', 'decimal') >> #item->type)]
			[loop: self->size]
				[self->(get: loop_count) %= #item]
			[/loop]
		[/if]
	[/Define_Tag]

	[Define_Tag: 'onConvert', -Required='type']
		[local: 'result' = (exVector)]
		[loop: self->size]
			[#result->(insert: '(' + (string: self->(get: loop_count)) + ')' )]
		[/loop]
		[return: self->type + ': ' + #result->(join: ', ')]
	[/Define_Tag]
	
[/Define_Type]

<h3>
	<font color="red">Lasso Summit - October 2002</font>
	<br><font color="green">Advanced Developer Techniques</font>
	<br><font color="blue">exVector Example</font>
	<br>By Fletcher Sandbeck
</h3>

<p>This file creates a data type exVector that implements overrides mathematical symbols
using custom tags.  The exVector data type supports performing mathematical operations on
all the elements of a vector at once.  Two vectors can be combined using mathematical
symbols or one vector can be modified by a scalar value.

<p>Check the unprocessed source of this page to see the definition of the exVector type.

<p>The following examples show how the exVector tag can be used.


<p><font color="red"><b>Create a Vector and Use Array Tags</b></font>

<p>This code creates an exVector object and examines it using the array tags that it
inherits.

<pre>[NoProcess]
[var: 'myVector' = (exVector: 1, 2, 3, 4, 5)]
<br>Type: [output: $myVector->Type]
<br>Size: [output: $myVector->Size]
<br>Get 3: [output: $myVector->(Get: 3)]
<br>Contains 5: [output: $myVector >> 5]
<br>String: [string: $myVector]
<br>Is an Array: [$myVector->(IsA: 'array')]
[/NoProcess]</pre>

<p>>>>>
[var: 'myVector' = (exVector: 1, 2, 3, 4, 5)]
<br>Type: [output: $myVector->Type]
<br>Size: [output: $myVector->Size]
<br>Get 3: [output: $myVector->(Get: 3)]
<br>Contains 5: [output: $myVector >> 5]
<br>String: [string: $myVector]
<br>Is an Array: [$myVector->(IsA: 'array')]



<p><font color="green"><b>Vector Math</b></font>

<p>This code creates two exVector objects and uses the mathematical symbols to manipulate them.

<pre>[NoProcess]
[var: 'myVector1' = (exVector: 1, 2, 3, 4, 5)]
[var: 'myVector2' = (exVector: 5, 4, 3, 2, 1)]
<br>Vector Alpha: [output: $myVector1]
<br>Vector Beta: [output: $myVector2]
<br>Alpha + Beta: [output: $myVector1 + $myVector2]
<br>Alpha - Beta: [output: $myVector1 - $myVector2]
<br>Alpha * Beta: [output: $myVector1 * $myVector2]
[/NoProcess]</pre>

<p>>>>>
[var: 'myVector1' = (exVector: 1, 2, 3, 4, 5)]
[var: 'myVector2' = (exVector: 5, 4, 3, 2, 1)]
<br>Vector Alpha: [output: $myVector1]
<br>Vector Beta: [output: $myVector2]
<br>Alpha + Beta: [output: $myVector1 + $myVector2]
<br>Alpha - Beta: [output: $myVector1 - $myVector2]
<br>Alpha * Beta: [output: $myVector1 * $myVector2]



<p><font color="green"><b>Scalar Math</b></font>

<p>This code creates an exVector object and a scalar and uses the mathematical symbols to manipulate them.

<pre>[NoProcess]
[var: 'myVector' = (exVector: 1, 2, 3, 4, 5)]
[var: 'myScalar' = 10]
<br>Vector: [output: $myVector]
<br>Scalar: [output: $myScalar]
<br>Alpha + Beta: [output: $myVector + $myScalar]
<br>Alpha - Beta: [output: $myVector - $myScalar]
<br>Alpha * Beta: [output: $myVector * $myScalar]
[/NoProcess]</pre>

<p>>>>>
[var: 'myVector' = (exVector: 1, 2, 3, 4, 5)]
[var: 'myScalar' = 10]
<br>Vector: [output: $myVector]
<br>Scalar: [output: $myScalar]
<br>Vector + Scalar: [output: $myVector + $myScalar]
<br>Vector - Scalar: [output: $myVector - $myScalar]
<br>Vector * Scalar: [output: $myVector * $myScalar]

<p>&nbsp;