#!/usr/local/bin/perl
# install_mod.cgi
# Download and install a webmin module

require './webmin-lib.pl';
if ($ENV{REQUEST_METHOD} eq "POST") { &ReadParseMime(); }
else { &ReadParse(); $no_upload = 1; }

if ($in{'source'} == 0) {
	# from local file
	&error_setup(&text('install_err1', $in{'file'}));
	$file = $in{'file'};
	if (!(-r $file)) { &inst_error($text{'install_efile'}); }
	}
elsif ($in{'source'} == 1) {
	# from uploaded file
	&error_setup($text{'install_err2'});
	$file = &tempname();
	$need_unlink = 1;
	if ($no_upload) {
                &inst_error($text{'install_ebrowser'});
                }
	open(MOD, "> $file");
	print MOD $in{'upload'};
	close(MOD);
	}
elsif ($in{'source'} == 2) {
	# from ftp or http url
	&error_setup(&text('install_err3', $in{'url'}));
	$file = &tempname();
	$need_unlink = 1;
	if ($in{'url'} =~ /^http:\/\/([^\/]+)(\/.*)$/) {
		$host = $1; $page = $2; $port = 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $file);
		}
	elsif ($in{'url'} =~ /^ftp:\/\/([^\/]+)\/(.*)$/) {
		$host = $1; $ffile = $2;
		&ftp_download($host, $ffile, $file);
		}
	else { &inst_error($text{'install_eurl'}); }
	}

# Uncompress the module file if needed
open(MFILE, $file);
read(MFILE, $two, 2);
close(MFILE);
if ($two eq "\037\235") {
	if (!&has_command("uncompress")) {
		unlink($file) if ($need_unlink);
		&error(&text('install_ecomp', "<tt>uncompress</tt>"));
		}
	local $temp = $file =~ /\/([^\/]+)\.Z/i ? &tempname("$1")
						: &tempname();
	local $out = `uncompress -c $file 2>&1 >$temp`;
	unlink($file) if ($need_unlink);
	if ($?) {
		unlink($temp);
		&error(&text('install_ecomp2', $out));
		}
	$file = $temp;
	$need_unlink = 1;
	}
elsif ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($file) if ($need_unlink);
		&error(&text('install_egzip', "<tt>gunzip</tt>"));
		}
	local $temp = $file =~ /\/([^\/]+)\.gz/i ? &tempname("$1")
						 : &tempname();
	local $out = `gunzip -c $file 2>&1 >$temp`;
	unlink($file) if ($need_unlink);
	if ($?) {
		unlink($temp);
		&error(&text('install_egzip2', $out));
		}
	$file = $temp;
	$need_unlink = 1;
	}

# Check if this is an RPM webmin module
open(TYPE, "../install-type");
chop($type = <TYPE>);
close(TYPE);
if ($type eq 'rpm' && ($out = `rpm -qp $file 2>/dev/null`)) {
	# Looks like an RPM of some kind, hopefully an RPM webmin module
	$out =~ /^wbm-([^\s\-]+)/ || &inst_error($text{'install_erpm'});
	$redirect_to = $name = $1;
	$out = &backquote_logged("rpm -U $file 2>&1");
	if ($?) {
		&inst_error(&text('install_eirpm', "<tt>$out</tt>"));
		}

	# Get the new module info
	chop($mdirs[0] = `cd ../$name ; pwd`);
	%minfo = &get_module_info($name);
	$mdescs[0] = $minfo{'desc'};
	$msizes[0] = &disk_usage_kb("../$name");

	# Update the ACL for this user
	&read_acl(undef, \%acl);
	open(ACL, "> ".&acl_filename());
	foreach $u (keys %acl) {
		@mods = @{$acl{$u}};
		if ($u eq $ENV{'REMOTE_USER'}) {
			push(@mods, $name);
			@mods = &unique(@mods);
			}
		print ACL "$u: ",join(' ', @mods),"\n";
		}
	close(ACL);
	&webmin_log("install", undef, $name, { 'desc' => $mdescs[0] });
	}
else {
	# Check if this is a valid module (a tar file of multiple module dirs)
	$tar = `tar tf "$file" 2>&1`;
	if ($?) { &inst_error(&text('install_etar', $tar)); }
	foreach $f (split(/\n/, $tar)) {
		if ($f =~ /^\.\/([^\/]+)\/(.*)$/ || $f =~ /^([^\/]+)\/(.*)$/) {
			$redirect_to = $1 if (!$redirect_to);
			$mods{$1}++;
			$hasfile{$1,$2}++;
			}
		}
	foreach $m (keys %mods) {
		$hasfile{$m,"module.info"} ||
			&inst_error(&text('install_einfo', "<tt>$m</tt>"));
		}
	if (!%mods) {
		&inst_error($text{'install_enone'});
		}

	# Get the module.info files to check dependancies
	$ver = &get_webmin_version();
	$tmpdir = &tempname();
	mkdir($tmpdir, 0700);
	foreach $m (keys %mods) {
		local %minfo;
		system("cd $tmpdir ; tar xf \"$file\" $m/module.info ./$m/module.info");
		if (!&read_file("$tmpdir/$m/module.info", \%minfo)) {
			$err = &text('install_einfo', "<tt>$m</tt>");
			}
		elsif (!&check_os_support(\%minfo)) {
			$err = &text('install_eos', "<tt>$m</tt>",
				     $gconfig{'real_os_type'},
				     $gconfig{'real_os_version'});
			}
		else {
			foreach $dep (split(/\s+/, $minfo{'depends'})) {
				if ($dep =~ /^[0-9\.]+$/) {
					if ($dep > $ver) {
						$err = &text('install_ever',
							"<tt>$m</tt>", "<tt>$dep</tt>");
						}
					}
				elsif (!-r "../$dep/module.info") {
					$err = &text('install_edep',
						     "<tt>$m</tt>", "<tt>$dep</tt>");
					}
				}
			}
		last if ($err);
		}
	system("rm -rf $tmpdir >/dev/null 2>&1");
	&inst_error($err) if ($err);

	# Delete modules being replaced
	foreach $m (keys %mods) {
		system("rm -rf ../$m 2>&1 >/dev/null") if ($m ne 'webmin');
		}

	# Extract all the modules and update perl path and ownership
	$out = `cd .. ; tar xf "$file" 2>&1 >/dev/null`;
	if ($?) { &inst_error(&text('install_eextract', $out)); }
	if ($need_unlink) { unlink($file); }
	open(PERL, $0);
	<PERL> =~ /^#!(\S+)/; $perl = $1;
	close(PERL);
	@st = stat($0);
	foreach $moddir (keys %mods) {
		chdir("../$moddir");
		%minfo = &get_module_info($moddir); push(@mdescs, $minfo{'desc'});
		chop($pwd = `pwd`); push(@mdirs, $pwd);
		push(@msizes, &disk_usage_kb("."));
		system("(find . -name '*.cgi' ; find . -name '*.pl') 2>/dev/null | xargs $perl ../perlpath.pl $perl");
		system("chown -R $st[4]:$st[5] .");
		&webmin_log("install", undef, $moddir, { 'desc' => $minfo{'desc'} });
		}

	# Copy appropriate config file from module to /etc/webmin
	system("$perl ../copyconfig.pl $gconfig{'os_type'} $gconfig{'os_version'} .. $config_directory ".join(' ', keys %mods));

	# Update ACL for this user so they can access the new modules
	&read_acl(undef, \%acl);
	open(ACL, "> ".&acl_filename());
	foreach $u (keys %acl) {
		@mods = @{$acl{$u}};
		if ($u eq $ENV{'REMOTE_USER'}) {
			push(@mods, keys %mods);
			@mods = &unique(@mods);
			}
		print ACL "$u: ",join(' ', @mods),"\n";
		}
	close(ACL);
	}

if ($in{'redirect'}) {
	# Redirect to the new module
	&redirect("/$redirect_to/");
	}
else {
	# Display something nice for the user
	&header($text{'install_title'}, "");
	print "<hr>\n";
	print "$text{'install_desc'} <p>\n";
	print "<ul>\n";
	for($i=0; $i<@mdescs; $i++) {
		print &text('install_line', "<b>$mdescs[$i]</b>",
			    "<tt>$mdirs[$i]</tt>", $msizes[$i]),"<p>\n";
		}
	print "</ul><p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	}

sub inst_error
{
if ($need_unlink) { unlink($file); }
&error(@_);
}

