#!/usr/local/bin/perl
# edit_upgrade.cgi
# Display a form for upgrading all of webmin from a tarfile

require './webmin-lib.pl';
&header($text{'upgrade_title'}, "");
print "<hr>\n";

# what kind of install was this?
if (open(MODE, "../install-type")) {
	chop($mode = <MODE>);
	close(MODE);
	}
else {
	chop($pwd = `cd .. ; pwd`);
	if ($pwd eq "/usr/libexec/webmin") {
		$mode = "rpm";
		}
	elsif ($pwd eq "/opt/webmin") {
		$mode = "solaris-pkg";
		}
	else {
		$mode = undef;
		}
	}

if ($mode eq "solaris-pkg") {
	print "<p>$text{'upgrade_esolaris'}<p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

print "<table width=100%><tr><td valign=top>\n";
print $text{"upgrade_desc$mode"},"</td><td valign=top>";

print "<form action=upgrade.cgi method=post enctype=multipart/form-data>\n";
print "<input type=hidden name=mode value='$mode'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'upgrade_title'}</b></td> </tr>\n";
print "<tr $cb> <td>\n";
print "<input type=radio name=source value=0 checked> $text{'upgrade_local'}\n";
print "<input name=file size=40>\n";
print &file_chooser_button("file", 0),"<br>\n";
print "<input type=radio name=source value=1> $text{'upgrade_uploaded'}\n";
print "<input name=upload type=file size=30><br>\n";
if ($mode eq 'caldera') {
	print "<input type=radio name=source value=3> $text{'upgrade_cup'}\n";
	}
else {
	print "<input type=radio name=source value=2> $text{'upgrade_ftp'}\n";
	}
print "</td></tr></table><br>\n";
print "<input type=submit value=\"$text{'upgrade_ok'}\">\n";
print "</form></td></tr></table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

