# space-monitor.pl
# Check the free space on some filesystem

sub get_space_status
{
&foreign_require("mount", "mount-lib.pl");
local $m;
foreach $f (&foreign_call("mount", "list_mounted")) {
	$m = $f if ($f->[0] eq $_[0]->{'fs'});
	}
if ($m) {
	local @sp = &foreign_call("mount", "disk_space", $m->[2], $m->[0]);
	if ($sp[1] < $_[0]->{'min'}) {
		return { 'up' => 0 };
		}
	else {
		return { 'up' => 1,
			 'desc' => &text('space_desc', $sp[1]) };
		}
	}
else {
	return { 'up' => -1,
		 'desc' => $text{'space_nofs'} };
	}
}

sub show_space_dialog
{
&foreign_require("mount", "mount-lib.pl");
print "<tr> <td><b>$text{'space_fs'}</b></td>\n";
print "<td><select name=fs>\n";
foreach $f (&foreign_call("mount", "list_mounted")) {
	printf "<option %s>%s\n",
		$_[0]->{'fs'} eq $f->[0] ? 'selected' : '', $f->[0]
		if ($f->[2] !~ /swap|proc|auto/);
	}
print "</select></td>\n";

print "<td><b>$text{'space_min'}</b></td>\n";
print "<td><input name=min size=8 value='$_[0]->{'min'}'></td> </tr>\n";
}

sub parse_space_dialog
{
&depends_check($_[0], "mount");
$in{'min'} =~ /^\d+$/ || &error($text{'space_emin'});
$_[0]->{'min'} = $in{'min'};
$_[0]->{'fs'} = $in{'fs'};
}

