#!/usr/local/bin/perl
# save_serv.cgi
# Save or delete a server

require './servers-lib.pl';
&ReadParse();
$access{'edit'} || &error($text{'edit_ecannot'});
&error_setup($text{'save_err'});

if ($in{'id'}) {
	$serv = &get_server($in{'id'});
	&can_use_server($serv) || &error($text{'edit_ecannot'});
	}

if ($in{'delete'}) {
	# delete the server
	&delete_server($in{'id'});
	&webmin_log("delete", "server", $serv->{'host'}, $serv); 
	}
else {
	# validate inputs
	$in{'host'} =~ /^\S+$/ || &error($text{'save_ehost'});
	$in{'port'} =~ /^\d+$/ || &error($text{'save_eport'});
	if ($in{'mode'}) {
		$in{'user'} =~ /\S/ || &error($text{'save_euser'});
		$in{'pass'} =~ /\S/ || &error($text{'save_epass'});
		}

	# save the server
	%serv = ( 'host' => $in{'host'},
		  'port' => $in{'port'},
		  'type' => $in{'type'},
		  'ssl' => $in{'ssl'},
		  'desc' => $in{'desc_def'} ? undef : $in{'desc'} );
	if ($in{'mode'}) {
		$serv{'user'} = $in{'user'};
		$serv{'pass'} = $in{'pass'};
		}
	$serv{'id'} = $in{'new'} ? time() : $in{'id'};
	&save_server(\%serv);
	&webmin_log($in{'new'} ? 'create' : 'modify', 'server',
		    $serv{'host'}, \%serv);
	}
&redirect("");

