#!/usr/local/bin/perl
# list_cgs.cgi
# List domains for which outgoing address mapping is done

require './sendmail-lib.pl';
$access{'cgs'} || &error($text{'cgs_ecannot'});
&header($text{'cgs_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
foreach $f (&find_type("F", $conf)) {
	if ($f->{'value'} =~ /^G[^\/]*(\/\S+)/) { $cgfile = $1; }
	}
if ($cgfile) {
	# get domains listed in a separate file
	open(CG, $cgfile);
	while(<CG>) {
		s/\r|\n//g;
		s/#.*$//g;
		if (/\S/) { push(@dlist, $_); }
		}
	close(CG);
	}

# Add domains from sendmail.cf
foreach $f (&find_type("C", $conf)) {
	if ($f->{'value'} =~ /^G\s*(.*)$/) {
		push(@dlist, split(/\s+/, $1));
		}
	}

print "<form method=post action=save_cgs.cgi enctype=multipart/form-data>\n";
print "<input type=hidden name=cgfile value=\"$cgfile\">\n";
print "<table cellpadding=5 width=100%><tr><td valign=top nowrap>\n";
print "<b>$text{'cgs_header'}</b><br>\n";
print "<textarea name=dlist rows=15 cols=65>",
	join("\n", @dlist),"</textarea><br>\n";
print "<input type=submit value=\"$text{'save'}\">\n";

print "</td><td valign=top>\n";
print &text('cgs_desc', "list_generics.cgi"),"<p>\n";
print "</td></tr></table>\n";
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

