#!/usr/local/bin/perl
# save_dns.cgi
# Save DNS client configuration

require './net-lib.pl';
$access{'dns'} == 2 || &error($text{'dns_ecannot'});
&error_setup($text{'dns_err'});
&ReadParse();

$in{'hostname'} =~ /^[A-z0-9\.\-]*$/ ||
	&error(&text('dns_ehost', $in{'hostname'}));
$dns = { };
for($i=0; $i<$max_dns_servers; $i++) {
	$ns = $in{"nameserver_$i"};
	if ($ns) {
		&check_ipaddress($ns) ||
			&error(&text('dns_ens', $ns));
		push(@{$dns->{'nameserver'}}, $ns);
		}
	}
if (!$in{'domain_def'}) {
	@dlist = split(/\s+/, $in{'domain'});
	foreach $d (@dlist) {
		$d =~ /^[A-z0-9\.\-]+$/ ||
			&error(&text('dns_edomain', $d));
		push(@{$dns->{'domain'}}, $d);
		}
	@dlist>0 || &error($text{'dns_esearch'});
	}
&parse_order($dns);
&save_dns_config($dns);
&save_hostname($in{'hostname'});
&webmin_log("dns", undef, undef, \%in);
&redirect("");

