# lpadmin-lib.pl
# Functions for configuring and adding printers

do '../web-lib.pl';
&init_config();
do "./$config{'print_style'}-lib.pl";
do "./$config{'driver_style'}-driver.pl";
%access = &get_module_acl();

$drivers_directory = "$module_config_directory/drivers";

# dev_name(file)
sub dev_name
{
local($i);
for($i=0; $i<@device_files; $i++) {
	if ($device_files[$i] eq $_[0]) { return $device_names[$i]; }
	}
return $_[0];
}

# has_ghostscript()
# Does this system have ghostscript installed?
sub has_ghostscript
{
return &has_command($config{'gs_path'});
}

# has_smbclient()
# Does this system have smbclient installed?
sub has_smbclient
{
return &has_command($config{'smbclient_path'});
}

# has_hpnp()
# Does this system have hpnp installed?
sub has_hpnp
{
return &has_command($config{'hpnp_path'});
}

# create_webmin_driver(&printer, &driver)
# lpadmin drivers are files in /etc/webmin/lpadmin/drivers. Each is a
# dynamically generated shell script which calls GS
sub create_webmin_driver
{
# check for non-driver
if ($_[1]->{'mode'} == 0) {
	return undef;
	}
elsif ($_[1]->{'mode'} == 2) {
	return $_[1]->{'program'};
	}

local($drv, $d, $gsdrv, $res, $perl);
&lock_file($drivers_directory);
mkdir($drivers_directory, 0755);
&unlock_file($drivers_directory);
$drv = "$drivers_directory/$_[0]->{'name'}";

# Find ghostscript driver
if ($_[1]->{'mode'} == 3) {
	$gsdrv = 'uniprint';
	}
else {
	foreach $d (&list_webmin_drivers()) {
		if ($d->[1] eq $_[1]->{'type'}) {
			$gsdrv = $d->[0];
			}
		}
	}

# Create script to call GS
&lock_file($drv);
open(DRV, ">$drv");
print DRV "#!/bin/sh\n";
print DRV "# Name: $_[0]->{'name'}\n";
print DRV "# Type: ",$_[1]->{'upp'} ? 'uniprint' : $_[1]->{'type'},"\n";
print DRV "# DPI: ",$_[1]->{'upp'} ? $_[1]->{'upp'} : $_[1]->{'dpi'},"\n";
if ($gconfig{'ld_env'}) {
	print DRV "$gconfig{'ld_env'}=$gconfig{'ld_path'}\n";
	}
print DRV "PATH=$gconfig{'path'}\n";
if ($config{'gs_fontpath'}) {
	print DRV "GS_FONTPATH=$config{'gs_fontpath'}\n";
	}
if ($config{'gs_lib'}) {
	print DRV "GS_LIB=$config{'gs_lib'}\n";
	}
print DRV "export $gconfig{'ld_env'} PATH GS_FONTPATH GS_LIB\n";
$res = $_[1]->{'upp'} ? "\@$_[1]->{'upp'}.upp" :
       $_[1]->{'dpi'} ? "-r$_[1]->{'dpi'}" : "";
open(PERL, "$config_directory/perl-path");
chop($perl = <PERL>);
close(PERL);
if ($config{'iface_arg'}) {
	for($i=0; $i<$config{'iface_arg'}-1; $i++) {
		print DRV "shift\n";
		}
	print DRV "cat \$* | $perl -e 'while(<STDIN>) { print if (!/^\\s*#####/); }' >/tmp/\$\$.gsin\n";
	}
else {
	print DRV "$perl -e 'while(<STDIN>) { print if (!/^\\s*#####/); }' >/tmp/\$\$.gsin\n";
	}
print DRV "$config{'gs_path'} -sOutputFile=/tmp/\$\$.gs -dSAFER -sDEVICE=$gsdrv $res -dNOPAUSE /tmp/\$\$.gsin </dev/null >/dev/null 2>&1\n";
print DRV "rm /tmp/\$\$.gsin\n";
print DRV "cat /tmp/\$\$.gs\n";
print DRV "rm /tmp/\$\$.gs\n";
close(DRV);
&unlock_file($drv);
&system_logged("chmod $config{'iface_perms'} $drv >/dev/null 2>&1");
if ($config{'iface_owner'}) {
	&system_logged("chown $config{'iface_owner'} $drv >/dev/null 2>&1");
	}
return $drv;
}

# create_webmin_windows_driver(&printer, &driver)
# Create an interface program that can print to a remote windows printer
# using some printer driver
sub create_webmin_windows_driver
{
local($drv, $prog);
&lock_file($drivers_directory);
mkdir($drivers_directory, 0755);
&unlock_file($drivers_directory);
$drv = "$drivers_directory/$_[0]->{'name'}.smb";

# Create script to call smbclient
&lock_file($drv);
open(DRV, ">$drv");
print DRV "#!/bin/sh\n";
print DRV "# Name: $_[0]->{'name'}\n";
print DRV "# Server: $_[1]->{'server'}\n";
print DRV "# Share: $_[1]->{'share'}\n";
print DRV "# User: $_[1]->{'user'}\n";
print DRV "# Password: $_[1]->{'pass'}\n";
print DRV "# Workgroup: $_[1]->{'workgroup'}\n";
print DRV "# Program: $_[1]->{'program'}\n";
if ($gconfig{'ld_env'}) {
	print DRV "$gconfig{'ld_env'}=$gconfig{'ld_path'}\n";
	}
print DRV "PATH=$gconfig{'path'}\n";
print DRV "export $gconfig{'ld_env'} PATH\n";
if (!$_[1]->{'program'}) {
	if ($config{'iface_arg'}) {
		for($i=0; $i<$config{'iface_arg'}-1; $i++) {
			print DRV "shift\n";
			}
		print DRV "cat \$* >/tmp/\$\$.smb\n";
		}
	else { print DRV "cat >/tmp/\$\$.smb\n"; }
	}
else {
	print DRV "$_[1]->{'program'} \"\$1\" \"\$2\" \"\$3\" \"\$4\" ",
		  "\"\$5\" \"\$6\" \"\$7\" \"\$8\" \"\$9\" ",
		  "\"\$10\" \"\$11\" \"\$12\" \"\$13\" >/tmp/\$\$.smb\n";
	system("chmod a+rx $_[1]->{'program'}");
	}
print DRV "$config{'smbclient_path'} '\\\\$_[1]->{'server'}\\$_[1]->{'share'}' ",
	  $_[1]->{'pass'} ? $_[1]->{'pass'} : "-N",
	  $_[1]->{'user'} ? " -U $_[1]->{'user'}" : "",
	  $_[1]->{'workgroup'} ? " -W $_[1]->{'workgroup'}" : "",
	  " -c \"print /tmp/\$\$.smb\" -P\n";
print DRV "rm /tmp/\$\$.smb\n";
close(DRV);
&unlock_file($drv);
&system_logged("chmod $config{'iface_perms'} $drv >/dev/null 2>&1");
if ($config{'iface_owner'}) {
	&system_logged("chown $config{'iface_owner'} $drv >/dev/null 2>&1");
	}
return $drv;
}

# create_hpnp_driver(&printer, &driver)
# Create an interface program that can print to a hpnp server using some
# interface program
sub create_hpnp_driver
{
local($drv, $prog);
&lock_file($drivers_directory);
mkdir($drivers_directory, 0755);
&unlock_file($drivers_directory);
$drv = "$drivers_directory/$_[0]->{'name'}.hpnp";

# Create script to call hpnp
&lock_file($drv);
open(DRV, ">$drv");
print DRV "#!/bin/sh\n";
print DRV "# Name: $_[0]->{'name'}\n";
print DRV "# Server: $_[1]->{'server'}\n";
print DRV "# Port: $_[1]->{'port'}\n";
print DRV "# Program: $_[1]->{'program'}\n";
if ($gconfig{'ld_env'}) {
	print DRV "$gconfig{'ld_env'}=$gconfig{'ld_path'}\n";
	}
print DRV "PATH=$gconfig{'path'}\n";
print DRV "export $gconfig{'ld_env'} PATH\n";
if (!$_[1]->{'program'}) {
	if ($config{'iface_arg'}) {
		for($i=0; $i<$config{'iface_arg'}-1; $i++) {
			print DRV "shift\n";
			}
		print DRV "cat \$* >/tmp/\$\$.hpnp\n";
		}
	else { print DRV "cat >/tmp/\$\$.hpnp\n"; }
	}
else {
	print DRV "$_[1]->{'program'} \"\$1\" \"\$2\" \"\$3\" \"\$4\" ",
		  "\"\$5\" \"\$6\" \"\$7\" \"\$8\" \"\$9\" ",
		  "\"\$10\" \"\$11\" \"\$12\" \"\$13\" >/tmp/\$\$.hpnp\n";
	system("chmod a+rx $_[1]->{'program'}");
	}
print DRV "$config{'hpnp_path'} -x $_[1]->{'server'}",
	  $_[1]->{'port'} ? " -p $_[1]->{'port'}" : "",
	  " /tmp/\$\$.hpnp\n";
print DRV "rm /tmp/\$\$.hpnp\n";
close(DRV);
&system_logged("chmod $config{'iface_perms'} $drv >/dev/null 2>&1");
if ($config{'iface_owner'}) {
	&system_logged("chown $config{'iface_owner'} $drv >/dev/null 2>&1");
	}
&unlock_file($drv);
return $drv;
}

# is_webmin_driver(path)
# Returns a structure of driver information
sub is_webmin_driver
{
local($l, $i, $u, $desc);
if (!$_[0]) {
	return { 'mode' => 0,
		 'desc' => 'None' };
	}
if (&has_ghostscript()) {
	open(DRV, $_[0]);
	for($i=0; $i<4; $i++) { $l .= <DRV>; }
	close(DRV);
	if ($l =~ /# Name: (.*)\n# Type: (.*)\n# DPI: (.*)\n/) {
		if ($2 eq 'uniprint') {
			local $upp = $3;
			foreach $u (&list_uniprint()) {
				$desc = $u->[1] if ($u->[0] eq $upp);
				}
			$desc =~ s/,.*$//;
			return { 'mode' => 3,
				 'upp' => $upp,
				 'desc' => $desc ? $desc : $upp };
			}
		else {
			return { 'type' => $2,
				 'dpi' => $3,
				 'mode' => 1,
				 'desc' => $3 ? "$2 ($3 DPI)" : $2 };
			}
		}
	}
return { 'desc' => $_[0],
	 'prog' => $_[0],
	 'mode' => 2 };
}

# is_webmin_windows_driver(path)
# Returns a structure containing information about a windows driver, or undef
# Returns the server, share, username, password, workgroup, program
# if path is a webmin windows driver
sub is_webmin_windows_driver
{
local($i, $l);
if (!&has_smbclient()) { return undef; }
open(DRV, $_[0]);
for($i=0; $i<8; $i++) { $l .= <DRV>; }
close(DRV);
if ($l =~ /# Name: (.*)\n# Server: (.*)\n# Share: (.*)\n# User: (.*)\n# Password: (.*)\n# Workgroup: (.*)\n# Program: (.*)\n/) {
	return { 'server' => $2,
		 'share' => $3,
		 'user' => $4,
		 'pass' => $5,
		 'workgroup' => $6,
		 'program' => $7 };
	}
elsif ($l =~ /# Name: (.*)\n# Server: (.*)\n# Share: (.*)\n# User: (.*)\n# Password: (.*)\n# Program: (.*)\n/) {
	return { 'server' => $2,
		 'share' => $3,
		 'user' => $4,
		 'pass' => $5,
		 'program' => $7 };
	}
else { return undef; }
}

# delete_webmin_driver(name)
# Delete the drivers for some printer
sub delete_webmin_driver
{
&lock_file("$drivers_directory/$_[0]");
&lock_file("$drivers_directory/$_[0].smb");
&lock_file("$drivers_directory/$_[0].hpnp");
unlink("$drivers_directory/$_[0]");
unlink("$drivers_directory/$_[0].smb");
unlink("$drivers_directory/$_[0].hpnp");
&unlock_file("$drivers_directory/$_[0]");
&unlock_file("$drivers_directory/$_[0].smb");
&unlock_file("$drivers_directory/$_[0].hpnp");
}

# is_hpnp_driver(path, &printer)
# Returns a structure of hpnp details if path is a webmin hpnp driver
sub is_hpnp_driver
{
local($i, $l);
if (!&has_hpnp()) { return undef; }
open(DRV, $_[0]);
for($i=0; $i<5; $i++) { $l .= <DRV>; }
close(DRV);
if ($l =~ /# Name: (.*)\n# Server: (.*)\n# Port: (.*)\n# Program: (.*)\n/) {
	return { 'server' => $2,
		 'port' => $3,
		 'program' => $4 };
	}
else { return undef; }
}

# webmin_driver_input(&printer, &driver)
sub webmin_driver_input
{
local ($prn, $drv) = @_;

printf "<tr> <td><input type=radio name=drv value=0 %s> %s</td>\n",
	$drv->{'mode'} == 0 ? "checked" : "", $text{'webmin_none'};
print "<td>($text{'webmin_nonemsg'})</td> </tr>\n";

printf "<tr> <td><input type=radio name=drv value=2 %s> %s</td>\n",
	$drv->{'mode'} == 2 ? "checked" : "", $text{'webmin_prog'};
printf "<td><input name=iface value=\"%s\" size=35></td> </tr>\n",
	$drv->{'mode'} == 2 ? $drv->{'prog'} : "";

if (&has_ghostscript()) {
	local $out = `$config{'gs_path'} -help 2>&1`;
	if ($out =~ /Available devices:\n((\s+.*\n)+)/i) {
		print "<tr> <td valign=top>\n";
		printf "<input type=radio name=drv value=1 %s>\n",
			$drv->{'mode'} == 1 ? "checked" : "";
		print "$text{'webmin_driver'}</td> <td valign=top>";
		foreach $d (split(/\s+/, $1)) { $drvsupp{$d}++; }
		print "<select name=driver size=7>\n";
		foreach $d (&list_webmin_drivers()) {
			if ($drvsupp{$d->[0]}) {
				printf "<option %s>%s\n",
				    $d->[1] eq $drv->{'type'} ? "selected" : "",
				    $d->[1];
				}
			}
		print "</select>&nbsp;&nbsp;";
		print "<select name=dpi size=7>\n";
		printf "<option value=\"\" %s>Default\n",
			$drv->{'dpi'} ? "" : "selected";
		foreach $d (75, 100, 150, 200, 300, 600, 720, 1440) {
			printf "<option value=\"$d\" %s>$d DPI\n",
				$drv->{'dpi'} == $d ? "selected" : "";
			}
		print "</select></td> </tr>\n";

		if ($drvsupp{'uniprint'}) {
			print "<tr> <td valign=top>\n";
			printf "<input type=radio name=drv value=3 %s>\n",
				$drv->{'mode'} == 3 ? "checked" : "";
			print "$text{'webmin_uniprint'}</td> <td valign=top>";
			print "<select name=uniprint size=5>\n";
			foreach $u (&list_uniprint()) {
				printf "<option value=%s %s>%s\n",
				    $u->[0],
				    $u->[0] eq $drv->{'upp'} ? 'selected' : '',
				    $u->[1];
				}
			print "</select></td> </tr>\n";
			}
		}
	else {
		print "<tr> <td colspan=2>",
		      &text('webmin_edrivers', "<tt>$config{'gs_path'}</tt>"),
		      "</td> </tr>\n";
		}
	}
elsif ($config{'gs_path'}) {
	print "<tr> <td colspan=2>",
	      &text('webmin_egs', "<tt>$config{'gs_path'}</tt>"),
	      "</td> </tr>\n";
	}
return undef;
}

# parse_webmin_driver()
# Parse driver selection from %in and return a driver structure
sub parse_webmin_driver
{
if ($in{'drv'} == 0) {
	return { 'mode' => 0 };
	}
elsif ($in{'drv'} == 2) {
	(-x $in{'iface'}) || &error(&text('webmin_edriver', $in{'iface'}));
	return { 'mode' => 2,
		 'program' => $in{'iface'} };
	}
elsif ($in{'drv'} == 1) {
	return { 'mode' => 1,
		 'type' => $in{'driver'},
		 'dpi' => $in{'dpi'} };
	}
elsif ($in{'drv'} == 3) {
	return { 'mode' => 3,
		 'upp' => $in{'uniprint'} };
	}
}



# list_webmin_drivers()
sub list_webmin_drivers
{
local(@rv, $_);
open(DRIVERS, "drivers");
while(<DRIVERS>) {
	/^(\S+)\s+(.*)/;
	push(@rv, [ $1, $2 ]);
	}
close(DRIVERS);
return @rv;
}

# can_edit_printer(printer)
sub can_edit_printer
{
foreach $p (split(/\s+/, $access{'printers'})) {
	return 1 if ($p eq '*' || $p eq $_[0]);
	}
return 0;
}

# can_edit_jobs(printer)
sub can_edit_jobs
{
return 1 if ($access{'cancel'} == 1);
return 0 if ($access{'cancel'} == 0);
foreach $p (split(/\s+/, $access{'jobs'})) {
	return 1 if ($p eq $_[0]);
	}
return 0;
}

# list_uniprint()
# Returns a list of uniprint drivers support by the installed ghostscript
sub list_uniprint
{
local (@rv, $f, $d);
local $out = `$config{'gs_path'} -help 2>&1`;
if ($out =~ /Search path:\n((\s+.*\n)+)/i) {
	foreach $d (split(/\s+/, $1)) {
		next if ($d !~ /^\//);
		opendir(DIR, $d);
		while($f = readdir(DIR)) {
			next if ($f !~ /^(.*)\.upp$/);
			local $upp = $1;
			open(UPP, "$d/$f");
			local $line = <UPP>;
			close(UPP);
			next if ($line !~ /upModel="(.*)"/i);
			push(@rv, [ $upp, $1 ]);
			}
		closedir(DIR);
		}
	}
return sort { $a->[0] cmp $b->[0] } @rv;
}

sub log_info
{
local ($drv, $wdrv, $hdrv);
if (!$webmin_windows_driver) {
	$wdrv = &is_webmin_windows_driver($_[0]->{'iface'}, $_[0]);
	}
$wdrv = &is_windows_driver($_[0]->{'iface'}, $_[0]) if (!$wdrv);
$hdrv = &is_hpnp_driver($_[0]->{'iface'}, $_[0]);
local $iface = $wdrv ? $wdrv->{'program'} :
	       $hdrv ? $hdrv->{'program'} : $_[0]->{'iface'};

if (!$webmin_print_driver) {
	$drv = &is_webmin_driver($iface, $_[0]);
	}
$drv = &is_driver($iface, $_[0])
	if ($drv->{'mode'} == 0 || $drv->{'mode'} == 2);
$drv->{'desc'} =~ s/\([^\)]+\)$//;

return { 'driver' => $drv->{'desc'},
	 'mode' => $drv->{'mode'},
	 'dest' => $wdrv ? "\\\\$wdrv->{'server'}\\$wdrv->{'share'}" :
		   $hdrv ? "HPNP $hdrv->{'server'}:$hdrv->{'port'}" :
		   $_[0]->{'rhost'} ? "$_[0]->{'rhost'}:$_[0]->{'rqueue'}" :
		   $_[0]->{'dhost'} ? "$_[0]->{'dhost'}:$_[0]->{'dport'}" :
		   &dev_name($_[0]->{'dev'}) };
}

