#!/usr/local/bin/perl
# index.cgi
# Display a list of run-levels and the actions that are run at boot and
# shutdown time for each level

require './init-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
%access = &get_module_acl();
print "<hr>\n";

if ($config{'init_base'} && $access{'bootup'}) {
	# build list of normal and broken actions
	@iacts = &list_actions();
	foreach $a (@iacts) {
		@ac = split(/\s+/, $a);
		$nodemap{$ac[1]} = $ac[0];
		push(@acts, $ac[0]);
		push(@actsl, "0+$ac[0]");
		push(@actsf, $ac[0] =~ /^\// ? $ac[0]
					     : "$config{'init_dir'}/$ac[0]");
		}
	foreach $r (&list_runlevels()) {
		foreach $w ("S", "K") {
			foreach $a (&runlevel_actions($r, $w)) {
				@ac = split(/\s+/, $a);
				if (!$nodemap{$ac[2]}) {
					push(@acts, $ac[1]);
					push(@actsl,
					     "1+$r+$ac[0]+$ac[1]+$ac[2]+$w");
					push(@actsf, "$config{'init_base'}/rc$r.d/$w$ac[0]$ac[1]");
					}
				}
			}
		}

	if (!$config{'desc'}) {
		# Display actions by name only
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'index_title'}</b></td> </tr>\n";
		print "<tr $cb> <td><table width=100%>\n";
		$len = @acts; $len = int(($len+3)/4)*4;
		for($i=0; $i<$len; $i++) {
			if ($i%4 == 0) { print "<tr>\n"; }
			print "<td width=25%>";
			if ($acts[$i]) {
				print "<a href=\"edit_action.cgi?$actsl[$i]\">",
				      "$acts[$i]</a>\n";
				}
			print "</td>\n";
			if ($i%4 == 3) { print "</tr>\n"; }
			}
		print "</table></td></tr></table>\n";
		}
	else {
		# Display actions and descriptions
		if ($access{'bootup'} == 2) {
			# With form for changing boot mode
			print "<form action=save_bootup.cgi>\n";
			}
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_action'}</b></td> ",
		      "<td nowrap><b>$text{'index_boot'}</b></td> ";
		if ($config{'status_check'} == 2) {
			print "<td nowrap><b>$text{'index_status'}</b></td> ";
			}
		print "<td><b>$text{'index_desc'}</b></td> </tr>\n";
		local @boot = &get_inittab_runlevel();
		for($i=0; $i<@acts; $i++) {
			local ($boot, %daemon);
			foreach $s (&action_levels('S', $acts[$i])) {
				local ($l, $p) = split(/\s+/, $s);
				$boot = 1 if (&indexof($l, @boot) >= 0);
				}
			if ($boot && $config{'daemons_dir'} &&
			    &read_env_file("$config{'daemons_dir'}/$acts[$i]",
					   \%daemon)) {
				$boot = lc($daemon{'ONBOOT'}) eq 'yes' ? 1 : 0;
				}
			print "<tr $cb>\n";
			if ($access{'bootup'} == 2) {
				print "<td>$acts[$i]</td>\n";
				}
			else {
				print "<td><a href=\"edit_action.cgi?",
				      "$actsl[$i]\">$acts[$i]</a></td>\n";
				}
			local %has;
			$d = &html_escape(&init_description($actsf[$i],
				 $config{'status_check'} == 2 ? \%has : undef));
			if ($access{'bootup'} == 2 && $actsl[$i] =~ /^0/) {
				printf "<td><input type=radio name=$acts[$i] value=1 %s> %s\n", $boot ? 'checked' : '', $text{'yes'};
				printf "<input type=radio name=$acts[$i] value=0 %s> %s</td>\n", $boot ? '' : 'checked', $text{'no'};
				}
			else {
				print "<td>", $boot ? $text{'yes'} :
				      "<font color=#ff0000>$text{'no'}</font>",
				      "</td>\n";
				}
			if ($config{'status_check'} == 2) {
				print "<td>\n";
				local $out =
				    $has{'status'} ? `$actsf[$i] status` : '';
				if ($out =~ /running/i) {
					print $text{'yes'};
					}
				elsif ($out =~ /stopped/i) {
					print "<font color=#ff0000>",
					      "$text{'no'}</font>";
					}
				else {
					print "<br>";
					}
				print "</td>\n";
				}
			print "<td>",$d ? $d : "<br>","</td>\n";
			print "</tr>\n";
			}
		print "</table>\n";
		}
	if ($access{'bootup'} == 2) {
		print "<input type=submit value='$text{'save'}'></form>\n";
		}
	else {
		print "<a href='edit_action.cgi?2'>$text{'index_add'}</a><p>\n";
		}
	print "<hr>\n";
	}
elsif ($config{'local_script'} && $access{'bootup'}) {
	# Display local bootup script
	print &text('index_script',
		    "<tt>$config{'local_script'}</tt>"),"<br>\n";
	print "<form action=save_local.cgi method=post>\n";
	print "<textarea name=local rows=20 cols=80>";
	open(LOCAL, $config{'local_script'});
	while(<LOCAL>) { print; }
	close(LOCAL);
	print "</textarea><br>\n";
	print "<input type=submit value='$text{'save'}'></form>\n";
	print "<hr>\n";
	}

# reboot/shutdown buttons
print "<table cellpadding=5 width=100%>\n";
if ($access{'reboot'}) {
	print "<form action=reboot.cgi>\n";
	print "<tr> <td><input type=submit ",
	      "value=\"$text{'index_reboot'}\"></td>\n";
	print "</form>\n";
	print "<td>$text{'index_rebootmsg'}</td> </tr>\n";
	}

if ($access{'shutdown'}) {
	print "<form action=shutdown.cgi>\n";
	print "<tr> <td><input type=submit ",
	      "value=\"$text{'index_shutdown'}\"></td>\n";
	print "</form>\n";
	print "<td>$text{'index_shutdownmsg'}</td> </tr>\n";
	}
print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

