#!/usr/local/bin/perl
# find_zones.cgi
# Display zones matching some search

require './bind8-lib.pl';
&ReadParse();
&header($text{'find_title'}, "");
print "<hr>\n";
%access = &get_module_acl();

$conf = &get_config();
@zones = &find("zone", $conf);
print "<p>",&text('find_match', "<tt>$in{'search'}</tt>"),"<p>\n";

foreach $z (@zones) {
	$v = $z->{'value'};
	next if ($v eq "." || !&can_edit_zone(\%access, $v) ||
		 $v !~ /$in{'search'}/);
	$t = &find("type", $z->{'members'})->{'value'};
	push(@zlinks, "edit_$t.cgi?index=$z->{'index'}");
	push(@ztitles, &ip6int_to_net(&arpa_to_ip($v)));
	push(@zicons, "images/$t.gif");
	push(@ztypes, $text{"index_$t"});
	$len++;
	}

if ($len) {
	# sort list of zones
	@zorder = sort { $ztitles[$a] cmp $ztitles[$b] } (0 .. $len-1);
	@zlinks = map { $zlinks[$_] } @zorder;
	@ztitles = map { $ztitles[$_] } @zorder;
	@zicons = map { $zicons[$_] } @zorder;
	@ztypes = map { $ztypes[$_] } @zorder;

	if ($config{'show_list'}) {
		# display as list
		$mid = int((@zlinks+1)/2);
		print "<table width=100%><tr><td width=50% valign=top>\n";
		&zones_table([ @zlinks[0 .. $mid-1] ],
			     [ @ztitles[0 .. $mid-1] ],
			     [ @ztypes[0 .. $mid-1] ]);
		print "</td><td width=50% valign=top>\n";
		if ($mid < @zlinks) {
			&zones_table([ @zlinks[$mid .. $#zlinks] ],
				     [ @ztitles[$mid .. $#ztitles] ],
				     [ @ztypes[$mid .. $#ztypes] ]);
			}
		print "</td></tr></table>\n";
		}
	else {
		# display as icons
		&icons_table(\@zlinks, \@ztitles, \@zicons);
		}
	}
else {
	print "<b>$text{'find_none'}</b><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});


