#!/usr/local/bin/perl
# index.cgi
# List all webmin users

require './acl-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);

@glist = &list_groups();
foreach $g (@glist) {
	foreach $gm (@{$g->{'members'}}) {
		$ingroup{$gm} = $g;
		}
	}

@ulist = &list_users();
foreach $u (@ulist) {
	$me = $u if ($u->{'name'} eq $ENV{'REMOTE_USER'});
	}
@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
	$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
			       &list_modules();
map { $mcan{$_}++ } @mcan;

foreach $m (&list_modules()) {
	@minfo = &module_info($m);
	$modname{$m} = $minfo[2];
	}
print "<hr>\n";
print "<h3>$text{'index_users'}</h3>\n";
foreach $u (@ulist) {
	next if (!&can_edit_user($u->{'name'}));
	if (!$header) {
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_user'}</b></td>\n";
		print "<td><b>$text{'index_modules'}</b></td> </tr>\n";
		$header++;
		}
	print "<tr $cb>\n";
	printf "<td valign=top><a href=\"edit_user.cgi?user=%s\">%s</a></td>\n",
		&urlize($u->{'name'}), $u->{'name'};
	if ($u->{'risk'}) {
		# Just display risk and skill levels
		print "<td><table width=100% cellpadding=1 cellspacing=1><tr>\n";
		print "<td width=33%><b>$text{'edit_risk'}</b> : ",
		      $text{'edit_risk_'.$u->{'risk'}},"</td>\n";
		print "<td width=33%><b>$text{'edit_skill'}</b> : ",
		      $text{'skill_'.$u->{'skill'}},"</td>\n";
		print "<td width=33%></td>\n";
		print "</tr></table></td></tr>\n";
		}
	elsif ($ingroup{$u->{'name'}}) {
		# Display group membership
		print "<td><table width=100% cellpadding=1 cellspacing=1>\n";
		print "<tr> <td colspan=3>",&text('index_modgroups',
		      "<tt>$ingroup{$u->{'name'}}->{'name'}</tt>"),
		      "</td> </tr>\n";
		$done = 0;
		foreach $m (@{$u->{'ownmods'}}) {
			if ($done%3 == 0) { print "<tr>\n"; }
			print "<td width=33%>";
			if ($mcan{$m} && $access{'acl'}) {
				print "<a href='edit_acl.cgi?mod=",
				      &urlize($m),"&user=",
				      &urlize($u->{'name'}),
				      "'>$modname{$m}</a>";
				}
			else {
				print $modname{$m};
				}
			print "</td>\n";
			if ($done%3 == 2) { print "<tr>\n"; }
			$done++;
			}
		while($done++ % 3) { print "<td width=33%></td>\n"; }
		print "</table></td></tr>\n";
		}
	elsif ($config{'select'}) {
		# Display select input
		print "<form action=edit_acl.cgi><td>\n";
		print "<input type=hidden name=user value='$u->{'name'}'>\n";
		if ($access{'acl'}) {
			print "<input type=submit ",
			      "value='$text{'index_edit'}'>\n";
			}
		print "<select name=mod>\n";
		print "<option value=''>$text{'index_global'}\n";
		foreach $m (@{$u->{'modules'}}) {
			if ($modname{$m}) {
				print "<option value=$m>$modname{$m}\n";
				}
			}
		print "</select></td></form></tr>\n";
		}
	else {
		# Display as table of modules
		print "<td><table width=100% cellpadding=1 cellspacing=1>\n";
		print "<tr> <td width=33%>\n";
		if ($access{'acl'}) {
			print "<a href='edit_acl.cgi?mod=&user=",
			      &urlize($u->{'name'}),
			      "'>$text{'index_global'}</a></td>";
			$done = 1;
			}
		foreach $m (@{$u->{'modules'}}) {
			if ($modname{$m}) {
				if ($done%3 == 0) { print "<tr>\n"; }
				print "<td width=33%>";
				if ($mcan{$m} && $access{'acl'}) {
					print "<a href='edit_acl.cgi?mod=",
					      &urlize($m),"&user=",
					      &urlize($u->{'name'}),
					      "'>$modname{$m}</a>";
					}
				else {
					print $modname{$m};
					}
				print "</td>\n";
				if ($done%3 == 2) { print "<tr>\n"; }
				$done++;
				}
			}
		while($done++ % 3) { print "<td width=33%></td>\n"; }
		print "</table></td></tr>\n";
		}
	}
if ($header) {
	print "</table>\n";
	}
else {
	print "<b>$text{'index_nousers'}</b><p>\n";
	}
if ($access{'create'}) {
	print "<a href=edit_user.cgi>$text{'index_create'}</a>&nbsp;&nbsp;\n";
	print "<a href=convert_form.cgi>$text{'index_convert'}</a>&nbsp;&nbsp;\n";
	print "<a href=edit_user.cgi?risk=1>$text{'index_rcreate'}</a>\n"
		if ($gconfig{'eazel'});
	print "<p>\n";
	}

if ($access{'groups'}) {
	print "<hr>\n";
	print "<h3>$text{'index_groups'}</h3>\n";
	foreach $g (@glist) {
		if (!$gheader) {
			print "<table border width=100%>\n";
			print "<tr $tb> <td><b>$text{'index_group'}</b></td>\n";
			print "<td><b>$text{'index_members'}</b></td>\n";
			print "<td><b>$text{'index_modules'}</b></td> </tr>\n";
			$gheader++;
			}
		print "<tr $cb> <td valign=top>\n";
		printf "<a href='edit_group.cgi?group=%s'>%s</a></td>\n",
			&urlize($g->{'name'}), $g->{'name'};
		print "<td valign=top>",join(" ", @{$g->{'members'}}),
		      "&nbsp;</td>\n";
		if ($ingroup{$g->{'name'}}) {
			# Display group membership
			print "<td><table width=100% cellpadding=1 ",
			      "cellspacing=1>\n";
			print "<tr> <td colspan=3>",&text('index_modgroups',
			      "<tt>$ingroup{$g->{'name'}}->{'name'}</tt>"),
			      "</td> </tr>\n";
			$done = 0;
			foreach $m (@{$g->{'ownmods'}}) {
				if ($done%3 == 0) { print "<tr>\n"; }
				print "<td width=33%>";
				if ($mcan{$m} && $access{'acl'}) {
					print "<a href='edit_acl.cgi?mod=",
					      &urlize($m),"&user=",
					      &urlize($g->{'name'}),
					      "'>$modname{$m}</a>";
					}
				else {
					print $modname{$m};
					}
				print "</td>\n";
				if ($done%3 == 2) { print "<tr>\n"; }
				$done++;
				}
			while($done++ % 3) { print "<td width=33%></td>\n"; }
			print "</table></td></tr>\n";
			}
		else {
			# Display as table of modules
			print "<td><table width=100% cellpadding=1 ",
			      "cellspacing=1>\n";
			print "<tr> <td width=33%><a href='edit_acl.cgi?",
			      "mod=&user=",&urlize($g->{'name'}),
			      "'>$text{'index_global'}</a></td>";
			$done = 1;
			foreach $m (@{$g->{'modules'}}) {
				if ($modname{$m}) {
					if ($done%3 == 0) { print "<tr>\n"; }
					print "<td width=33%>";
					print "<a href='edit_acl.cgi?mod=",
					      &urlize($m),"&group=",
					      &urlize($g->{'name'}),
					      "'>$modname{$m}</a>";
					print "</td>\n";
					if ($done%3 == 2) { print "<tr>\n"; }
					$done++;
					}
				}
			while($done++ % 3) { print "<td width=33%></td>\n"; }
			print "</table></td></tr>\n";
			}
		}
	if ($gheader) {
		print "</table>\n";
		}
	else {
		print "<b>$text{'index_nogroups'}</b><p>\n";
		}
	print "<a href=edit_group.cgi>$text{'index_gcreate'}</a><p>\n";
	}

&get_miniserv_config(\%miniserv);
if (uc($ENV{'HTTPS'}) eq "ON" && $miniserv{'ca'}) {
	print "<hr>\n";
	print "<form action=cert_form.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value='$text{'index_cert'}'></td>\n";
	print "<td>$text{'index_certmsg'}</td>\n";
	print "</table></tr></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});


