#!/usr/local/bin/perl
# index.cgi
# Display all xinetd services

require './xinetd-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("xinetd", "man", "doc", "google"));
print "<hr>\n";

# Check for config file
if (!-r $config{'xinetd_conf'}) {
	print "<p>",&text('index_econf', "<tt>$config{'xinetd_conf'}</tt>",
			  "/config.cgi?$module_name"),"<p><hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
      "<td><b>$text{'index_type'}</b></td> ",
      "<td><b>$text{'index_port'}</b></td> ",
      "<td><b>$text{'index_proto'}</b></td> ",
      "<td><b>$text{'index_user'}</b></td> ",
      "<td><b>$text{'index_server'}</b></td> ",
      "<td><b>$text{'index_enabled'}</b></td> </tr>\n";
foreach $x (&get_xinetd_config()) {
	next if ($x->{'name'} ne 'service');
	local $q = $x->{'quick'};
	local @s;
	if ($q->{'protocol'}) {
		@s = getservbyname($x->{'value'}, $q->{'protocol'}->[0]);
		if (!@s) {
			@s = ( $x->{'name'}, undef, $q->{'port'}->[0],
			       $q->{'protocol'}->[0] );
			}
		}
	else {
		foreach $p (&list_protocols()) {
			@s = getservbyname($x->{'value'}, $p);
			last if (@s);
			}
		}
	print "<tr $cb>\n";
	print "<td><a href='edit_serv.cgi?idx=$x->{'index'}'>",
	      "$x->{'value'}</a></td>\n";
	print "<td>",&indexof('RPC', @{$q->{'type'}}) < 0 ?
		     $text{'index_inet'} : $text{'index_rpc'},"</td>\n";
	print "<td>$s[2]</td>\n";
	print "<td>",uc($s[3]),"</td>\n";
	print "<td>$q->{'user'}->[0]</td>\n";
	print "<td>",&indexof('INTERNAL', @{$q->{'type'}}) >= 0 ?
		     $text{'index_internal'} : $q->{'redirect'} ?
		     &text('index_redirect', "<tt>$q->{'redirect'}->[0]</tt>") :
		     $q->{'server'}->[0],"</td>\n";
	print "<td>",$q->{'disable'}->[0] eq 'yes' ?
	      "<font color=#ff0000>$text{'no'}</font>" : $text{'yes'},"</td>\n";
	print "</tr>\n";
	}
print "</table>\n";
print "<a href='edit_serv.cgi?new=1'>$text{'index_add_inet'}</a>&nbsp;&nbsp;\n";
print "<a href='edit_rpc.cgi?new=1'>$text{'index_add_rpc'}</a><p>\n";

print "<hr>\n";
print "<table>\n";
print "<form action=edit_defaults.cgi>\n";
print "<tr> <td><input type=submit value=\"$text{'index_defaults'}\"></td>\n";
print "<td>$text{'index_defaultsmsg'} \n";
print "</td> </tr>\n";
print "</form>\n";

if (open(PID, $config{'pid_file'})) {
	chop($pid = <PID>);
	close(PID);
	}
if ($pid && kill(0, $pid)) {
	print "<form action=restart.cgi>\n";
	print "<input type=hidden name=pid value=$pid>\n";
	print "<tr> <td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	print "<td>$text{'index_applymsg'} \n";
	print "</td></tr>\n";
	print "</form>\n";
	}
else {
	print "<form action=start.cgi>\n";
	print "<tr> <td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'} \n";
	print "</td> </tr>\n";
	print "</form>\n";
	}
print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

