#!/usr/local/bin/perl
# themes_theme.cgi
# Download and install a webmin theme

require './webmin-lib.pl';
if ($ENV{REQUEST_METHOD} eq "POST") { &ReadParseMime(); }
else { &ReadParse(); $no_upload = 1; }

if ($in{'source'} == 0) {
	# from local file
	&error_setup(&text('themes_err1', $in{'file'}));
	$file = $in{'file'};
	if (!(-r $file)) { &inst_error($text{'themes_efile'}); }
	}
elsif ($in{'source'} == 1) {
	# from uploaded file
	&error_setup($text{'themes_err2'});
	$file = &tempname();
	$need_unlink = 1;
	if ($no_upload) {
                &inst_error($text{'themes_ebrowser'});
                }
	open(MOD, "> $file");
	print MOD $in{'upload'};
	close(MOD);
	}
elsif ($in{'source'} == 2) {
	# from ftp or http url
	&error_setup(&text('themes_err3', $in{'url'}));
	$file = &tempname();
	$need_unlink = 1;
	if ($in{'url'} =~ /^http:\/\/([^\/]+)(\/.*)$/) {
		$host = $1; $page = $2; $port = 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $file);
		}
	elsif ($in{'url'} =~ /^ftp:\/\/([^\/]+)\/(.*)$/) {
		$host = $1; $ffile = $2;
		&ftp_download($host, $ffile, $file);
		}
	else { &inst_error($text{'themes_eurl'}); }
	}

# Uncompress the module file if needed
open(MFILE, $file);
read(MFILE, $two, 2);
close(MFILE);
if ($two eq "\037\235") {
	if (!&has_command("uncompress")) {
		unlink($file) if ($need_unlink);
		&error(&text('themes_ecomp', "<tt>uncompress</tt>"));
		}
	local $temp = $file =~ /\/([^\/]+)\.Z/i ? &tempname("$1")
						: &tempname();
	local $out = `uncompress -c $file 2>&1 >$temp`;
	unlink($file) if ($need_unlink);
	if ($?) {
		unlink($temp);
		&error(&text('themes_ecomp2', $out));
		}
	$file = $temp;
	$need_unlink = 1;
	}
elsif ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($file) if ($need_unlink);
		&error(&text('themes_egzip', "<tt>gunzip</tt>"));
		}
	local $temp = $file =~ /\/([^\/]+)\.gz/i ? &tempname("$1")
						 : &tempname();
	local $out = `gunzip -c $file 2>&1 >$temp`;
	unlink($file) if ($need_unlink);
	if ($?) {
		unlink($temp);
		&error(&text('themes_egzip2', $out));
		}
	$file = $temp;
	$need_unlink = 1;
	}

# Check if this is an RPM webmin theme
open(TYPE, "../install-type");
chop($type = <TYPE>);
close(TYPE);
if ($type eq 'rpm' && ($out = `rpm -qp $file 2>/dev/null`)) {
	# Looks like an RPM of some kind, hopefully an RPM webmin theme
	$out =~ /^wbt-([^\s\-]+)/ || &inst_error($text{'themes_erpm'});
	$name = $1;
	$out = &backquote_logged("rpm -U $file 2>&1");
	if ($?) {
		&inst_error(&text('themes_eirpm', "<tt>$out</tt>"));
		}

	# Get the new theme info
	chop($mdirs[0] = `cd ../$name ; pwd`);
	&read_file("../$name/theme.info", \%tinfo);
	$mdescs[0] = $tinfo{'desc_'.$current_lang} ?
			$tinfo{'desc_'.$current_lang} : $tinfo{'desc'};
	$msizes[0] = &disk_usage_kb("../$name");
	&webmin_log("tinstall", undef, $name, { 'desc' => $mdescs[0] });
	}
else {
	# Check if this is a valid theme (a tar file of multiple theme dirs)
	$tar = `tar tf $file 2>&1`;
	if ($?) { &inst_error(&text('themes_etar', $tar)); }
	foreach $f (split(/\n/, $tar)) {
		if ($f =~ /^\.\/([^\/]+)\/(.*)$/ || $f =~ /^([^\/]+)\/(.*)$/) {
			$mods{$1}++;
			$hasfile{$1,$2}++;
			}
		}
	foreach $m (keys %mods) {
		$hasfile{$m,"theme.info"} ||
			&inst_error(&text('themes_einfo', "<tt>$m</tt>"));
		}
	if (!%mods) {
		&inst_error($text{'themes_enone'});
		}

	# Delete themes being replaced
	foreach $t (keys %mods) {
		system("rm -rf ../$t 2>&1 >/dev/null");
		}

	# Extract all the themes and update perl path and ownership
	$out = `cd .. ; tar xf $file 2>&1 >/dev/null`;
	if ($?) { &inst_error(&text('themes_eextract', $out)); }
	if ($need_unlink) { unlink($file); }
	open(PERL, $0);
	<PERL> =~ /^#!(\S+)/; $perl = $1;
	close(PERL);
	@st = stat($0);
	foreach $tdir (keys %mods) {
		chdir("../$tdir");
		undef(%tinfo); &read_file("../$tdir/theme.info", \%tinfo);
		push(@mdescs, $tinfo{'desc_'.$current_lang} ?
			      $tinfo{'desc_'.$current_lang} : $tinfo{'desc'});
		chop($pwd = `pwd`); push(@mdirs, $pwd);
		push(@msizes, &disk_usage_kb("."));
		system("(find . -name '*.cgi' ; find . -name '*.pl') 2>/dev/null | xargs $perl ../perlpath.pl $perl");
		system("chown -R $st[4]:$st[5] .");
		&webmin_log("tinstall", undef, $tdir,
			    { 'desc' => $mdescs[$#mdescs] });
		}
	}

# Display something nice for the user
&header($text{'themes_title'}, "");
print "<hr>\n";
print "$text{'themes_done'} <p>\n";
print "<ul>\n";
for($i=0; $i<@mdescs; $i++) {
	print &text('themes_line', "<b>$mdescs[$i]</b>",
		    "<tt>$mdirs[$i]</tt>", $msizes[$i]),"<p>\n";
	}
print "</ul><p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

sub inst_error
{
if ($need_unlink) { unlink($file); }
&error(@_);
}

