#!/usr/local/bin/perl

require './user-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("passwd group shadow gshadow", "man"));
$formno = 0;
%access = &get_module_acl();

@ulist = @allulist = &list_users();
@glist = @allglist = &list_groups();
foreach $g (@allglist) {
	$usedgid{$g->{'gid'}} = $g;
	}

# List all local users
if ($access{'uedit_mode'} == 1) {
	@ulist = ();
	}
elsif ($access{'uedit_mode'} == 2) {
	map { $canu{$_}++ } split(/\s+/, $access{'uedit'});
	@ulist = grep { $canu{$_->{'user'}} } @ulist;
	}
elsif ($access{'uedit_mode'} == 3) {
	map { $cannotu{$_}++ } split(/\s+/, $access{'uedit'});
	@ulist = grep { !$cannotu{$_->{'user'}} } @ulist;
	}
elsif ($access{'uedit_mode'} == 4) {
	@ulist = grep {
		(!$access{'uedit'} || $_->{'uid'} >= $access{'uedit'}) &&
		(!$access{'uedit2'} || $_->{'uid'} <= $access{'uedit2'})
			} @ulist;
	}
elsif ($access{'uedit_mode'} == 5) {
	map { $cangid{$_}++ } split(/\s+/, $access{'uedit'});
	@ulist = grep { $cangid{$_->{'gid'}} } @ulist;
	}
elsif ($access{'uedit_mode'} == 6) {
	@ulist = grep { $_->{'user'} eq $ENV{'REMOTE_USER'} } @ulist;
	}
if (@ulist > $config{'display_max'}) {
	# Display user search form
	print "<hr>\n";
	print "<b>$text{'index_toomany'}</b><br>\n";
	print "<form action=search_user.cgi>\n";
	print &hlink("<b>$text{'index_find'}</b>","findform"),
	      " <select name=field>\n";
	print "<option value=user checked>$text{'user'}\n";
	print "<option value=real>$text{'real'}\n";
	print "<option value=shell>$text{'shell'}\n";
	print "<option value=home>$text{'home'}\n";
	print "<option value=uid>$text{'uid'}\n";
	print "</select> <select name=match>\n";
	print "<option value=0 checked>$text{'index_equals'}\n";
	print "<option value=1>$text{'index_matches'}\n";
	print "<option value=2>$text{'index_nequals'}\n";
	print "<option value=3>$text{'index_nmatches'}\n";
	print "</select> <input name=what size=15>&nbsp;&nbsp;\n";
	print "<input type=submit value=\"$text{'find'}\"></form>\n";
	$formno++;
	}
elsif (@ulist) {
	# Display a table of all users
	print "<hr>\n";
	if ($config{'sort_mode'} == 1) {
		@ulist = sort { $a->{'user'} cmp $b->{'user'} } @ulist;
		}
	elsif ($config{'sort_mode'} == 2) {
		@ulist = sort { lc($a->{'real'}) cmp lc($b->{'real'}) } @ulist;
		}
	elsif ($config{'sort_mode'} == 3) {
		@ulist = sort { @wa = split(/\s+/, $a->{'real'});
				@wb = split(/\s+/, $b->{'real'});
				lc($wa[@wa-1]) cmp lc($wb[@wb-1]) } @ulist;
		}
	elsif ($config{'sort_mode'} == 4) {
		@ulist = sort { $a->{'shell'} cmp $b->{'shell'} } @ulist;
		}
	if ($access{'icons'}) {
		# Show an icon for each user
		print "<h3>$text{'index_users'}</h3>\n";
		local @icons = map { "images/user.gif" } @ulist;
		local @links = map { "edit_user.cgi?num=$_->{'num'}" } @ulist;
		local @titles = map { $_->{'user'} } @ulist;
		&icons_table(\@links, \@titles, \@icons, 5);
		}
	elsif ($config{'display_mode'} == 2) {
		# Show usernames under groups
		foreach $u (@ulist) {
			push(@{$ug{$u->{'gid'}}}, $u);
			}
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'index_ugroup'}</b></td> ",
		      "<td><b>$text{'index_users'}</b></td> </tr>\n";
		foreach $g (keys %ug) {
			print "<tr $cb> <td width=20%><b>",
			      "$usedgid{$g}->{'group'}</b></td>\n";
			print "<td width=80%><table width=100% ",
			      "cellpadding=0 cellspacing=0>\n";
			$i = 0;
			foreach $u (@{$ug{$g}}) {
				if ($i%4 == 0) { print "<tr>\n"; }
				print "<td width=25%><a href=\"edit_user.cgi?",
				      "num=$u->{'num'}\">",
				      "$u->{'user'}</a></td>\n";
				if ($i%4 == 3) { print "</tr>\n"; }
				$i++;
				}
			print "</table></td> </tr>\n";
			}
		print "</table>\n";
		}
	elsif ($config{'display_mode'} == 1) {
		# Show names, real names, home dirs and shells
		print "<h3>$text{'index_users'}</h3>\n";
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'user'}</b></td> ",
		      "<td><b>$text{'uid'}</b></td> ",
		      "<td><b>$text{'real'}</b></td> ",
		      "<td><b>$text{'home'}</b></td> ",
		      "<td><b>$text{'shell'}</b></td> </tr>\n";
		foreach $u (@ulist) {
			print "<tr $cb> <td><a href='edit_user.cgi?",
			      "num=$u->{'num'}'>$u->{'user'}</a></td> ",
			      "<td>$u->{'uid'}</td> ",
			      "<td>",&ifblank($u->{'real'}),"</td> ",
			      "<td>",&ifblank($u->{'home'}),"</td> ",
			      "<td>",&ifblank($u->{'shell'}),"</td> </tr>\n";
			}
		print "</table>\n";
		}
	else {
		# Just show names
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'index_users'}</b></td> </tr>\n";
		print "<tr $cb> <td><table width=100%>\n";
		for($i=0; $i<@ulist; $i++) {
			if ($i%4 == 0) { print "<tr>\n"; }
			print "<td><a href=\"edit_user.cgi?",
			      "num=$ulist[$i]->{'num'}\">",
			      "$ulist[$i]->{'user'}</a></td>\n";
			if ($i%4 == 3) { print "</tr>\n"; }
			}
		print "</table></td> </tr></table>\n";
		}
	}
elsif ($access{'ucreate'}) {
	print "<hr>\n";
	print "<b>$text{'index_notusers'}</b>. <p>\n";
	}
if ($access{'ucreate'}) {
	local $cancreate;
	if ($access{'hiuid'} && !$access{'umultiple'}) {
		foreach $u (@allulist) {
			$useduid{$u->{'uid'}}++;
			}
		for($i=int($access{'lowuid'}); $i<=$access{'hiuid'}; $i++) {
			if (!$useduid{$i}) {
				$cancreate = 1;
				last;
				}
			}
		}
	else { $cancreate = 1; }
	if ($cancreate) {
		print "<a href=\"edit_user.cgi\">",
		      "$text{'index_createuser'}</a>&nbsp;&nbsp;\n";
		}
	else {
		print "$text{'index_nomoreusers'}<br>\n";
		}
	}
print "<a href=\"batch_form.cgi\">$text{'index_batch'}</a><p>\n";

# List all local groups
if ($access{'gedit_mode'} == 1) {
	@glist = ();
	}
elsif ($access{'gedit_mode'} == 2) {
	map { $cang{$_}++ } split(/\s+/, $access{'gedit'});
	@glist = grep { $cang{$_->{'group'}} } @glist;
	}
elsif ($access{'gedit_mode'} == 3) {
	map { $cannotg{$_}++ } split(/\s+/, $access{'gedit'});
	@glist = grep { !$cannotg{$_->{'group'}} } @glist;
	}
elsif ($access{'gedit_mode'} == 4) {
	@glist = grep {
		(!$access{'gedit'} || $_->{'gid'} >= $access{'gedit'}) &&
		(!$access{'gedit2'} || $_->{'gid'} <= $access{'gedit2'})
			} @glist;
	}
if (@glist > $config{'display_max'}) {
	# Display group search form
	print "<hr>\n";
	print "<b>$text{'index_gtoomany'}</b><br>\n";
	print "<form action=search_group.cgi>\n";
	print &hlink("<b>$text{'index_gfind'}</b>","gfindform"),
	      " <select name=field>\n";
	print "<option value=group checked>$text{'gedit_group'}\n";
	print "<option value=members>$text{'gedit_members'}\n";
	print "<option value=gid>$text{'gedit_gid'}\n";
	print "</select> <select name=match>\n";
	print "<option value=0 checked>$text{'index_equals'}\n";
	print "<option value=1>$text{'index_matches'}\n";
	print "<option value=2>$text{'index_nequals'}\n";
	print "<option value=3>$text{'index_nmatches'}\n";
	print "</select> <input name=what size=15>&nbsp;&nbsp;\n";
	print "<input type=submit value=\"$text{'find'}\"></form>\n";
	$formno++;
	}
elsif (@glist) {
	print "<hr>\n";
	if ($config{'sort_mode'}) {
		@glist = sort { $a->{'group'} cmp $b->{'group'} } @glist;
		}
	if ($access{'icons'}) {
		# Show an icon for each group
		print "<h3>$text{'index_groups'}</h3>\n";
		local @icons = map { "images/group.gif" } @glist;
		local @links = map { "edit_group.cgi?num=$_->{'num'}" } @glist;
		local @titles = map { $_->{'group'} } @glist;
		&icons_table(\@links, \@titles, \@icons, 5);
		}
	elsif ($config{'display_mode'} == 1) {
		# Display group name, ID and members
		print "<h3>$text{'index_groups'}</h3>\n";
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'gedit_group'}</b></td> ",
		      "<td><b>$text{'gedit_gid'}</b></td> ",
		      "<td><b>$text{'gedit_members'}</b></td> </tr>\n";
		foreach $g (@glist) {
			print "<tr $cb> <td><a href='edit_group.cgi?",
			      "num=$g->{'num'}'>$g->{'group'}</a></td> ",
			      "<td>$g->{'gid'}</td> ",
			      "<td>",&ifblank($g->{'members'}),"</td> </tr>\n";
			}
		print "</table>\n";
		}
	else {
		# Just display group names
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'index_groups'}</b></td> </tr>\n";
		print "<tr $cb> <td><table width=100%>\n";
		for($i=0; $i<@glist; $i++) {
			if ($i%4 == 0) { print "<tr>\n"; }
			print "<td><a href=\"edit_group.cgi?",
			      "num=$glist[$i]->{'num'}\">",
			      "$glist[$i]->{'group'}</a></td>\n";
			if ($i%4 == 3) { print "</tr>\n"; }
			}
		print "</table></td> </tr></table>\n";
		}
	}
elsif ($access{'gcreate'} == 1) {
	print "<hr>\n";
	print "<b>$text{'index_notgroups'}</b>. <p>\n";
	}
if ($access{'gcreate'} == 1) {
	local $cancreate;
	if ($access{'higid'} && !$access{'gmultiple'}) {
		for($i=int($access{'lowgid'}); $i<=$access{'higid'}; $i++) {
			if (!$usedgid{$i}) {
				$cancreate = 1;
				last;
				}
			}
		}
	else { $cancreate = 1; }
	if ($cancreate) {
		print "<a href=\"edit_group.cgi\">$text{'index_creategroup'}</a> <p>\n";
		}
	else {
		print "$text{'index_nomoregroups'}<p>\n";
		}
	}

if ($access{'logins'}) {
	print "<hr>\n";
	print "<form action=list_logins.cgi>\n";
	print "<input type=submit value=\"$text{'index_logins'}\">\n";
	print "<input name=username size=8> ",
	      &user_chooser_button("username",0,$formno),"</form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});
 
sub ifblank
{
return $_[0] ? $_[0] : "&nbsp;";
}

