# log_parser.pl
# Functions for parsing this module's logs

require './software-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p, $long) = @_;
if ($action eq 'install') {
	return &text("log_install_package", "<tt>$object</tt>");
	}
elsif ($action eq 'apt') {
	local @p = split(/\0/, $p->{'packages'});
	return &text($long || @p < 2 ? "log_${type}_apt_l" : "log_${type}_apt",
		     "<tt>".join(" ",@p)."</tt>", scalar(@p));
	}
elsif ($action eq 'rhn') {
	local @p = @{$p->{'packages'}};
	return &text($long || @p < 2 ? "log_${type}_rhn_l" : "log_${type}_rhn",
		     "<tt>".join(" ",@p)."</tt>", scalar(@p));
	}
elsif ($action eq 'delete') {
	return &text('log_delete', "<tt>$object</tt>");
	}
else {
	return undef;
	}
}

