#!/usr/local/bin/perl
# apt_upgrade.cgi
# Upgrade a debian system

require './software-lib.pl';
&ReadParse();

&header($text{'apt_upgrade'}, "");

if ($in{'update'}) {
	print "<hr>\n";
	print "<b>",&text('apt_updatedesc',
			  "<tt>apt-get update</tt>"),"</b><p>\n";
	print "<pre>";
	&additional_log("exec", undef, "apt-get update");
	open(CMD, "apt-get update 2>&1 </dev/null |");
	while(<CMD>) {
		print;
		}
	close(CMD);
	print "</pre>\n";
	if ($?) {
		print "<b>$text{'apt_updatefailed'}</b><p>\n";
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}
	else { print "<b>$text{'apt_updateok'}</b><p>\n"; }
	}

print "<hr>\n";
$opts = $in{'sim'} ? "-s -y -f" : "-y -f";
$cmd = $in{'dist'} ? "dist-upgrade" : "upgrade";
print "<b>",&text($in{'sim'} ? 'apt_upgradedescsim' : 'apt_upgradedesc', "<tt>apt-get $opts $cmd</tt>"),"</b><p>\n";
print "<pre>";
&additional_log("exec", undef, "apt-get $opts $cmd");
open(CMD, "apt-get $opts $cmd 2>&1 </dev/null |");
while(<CMD>) {
	if (/setting\s+up\s+(\S+)/i) {
		push(@packs, $1);
		}
	elsif (/packages\s+will\s+be\s+upgraded/i ||
	       /new\s+packages\s+will\s+be\s+installed/i) {
		print;
		$line = $_ = <CMD>;
		$line =~ s/^\s+//; $line =~ s/\s+$//;
		push(@newpacks, split(/\s+/, $line));
		}
	print;
	}
close(CMD);
if (!@rv && $config{'package_system'} ne 'debian' && !$?) {
	# Other systems don't list the packages installed!
	@packs = @newpacks;
	}
print "</pre>\n";
if ($?) { print "<b>$text{'apt_upgradefailed'}</b><p>\n"; }
else { print "<b>$text{'apt_upgradeok'}</b><p>\n"; }

foreach $p (@packs) {
	local @pinfo = &show_package_info($p);
	}
&webmin_log("apt", "check", undef, { 'packages' => \@packs }) if (@packs);

print "<hr>\n";
&footer("", $text{'index_return'});

