#!/usr/local/bin/perl
# list_mailq.cgi
# Display the current mail queue

require './sendmail-lib.pl';
$access{'mailq'} || &error($text{'mailq_ecannot'});
print "Refresh: $config{'mailq_refresh'}\r\n"
	if ($config{'mailq_refresh'});
&header($text{'mailq_title'}, "");
print "<hr><p>\n";

$conf = &get_sendmailcf();
foreach $mqueue (&mailq_dir($conf)) {
	opendir(QDIR, $mqueue);
	push(@qfiles, map { "$mqueue/$_" } grep { /^qf/ } readdir(QDIR));
	closedir(QDIR);
	}

if (@qfiles) {
	print "<form action=del_mailqs.cgi>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> ";
	if ($access{'mailq'} == 2) {
		print "<td><br></td> ";
		}
	print "<td><b>$text{'mailq_id'}</b></td> ",
	      "<td><b>$text{'mailq_sent'}</b></td> ",
	      "<td><b>$text{'mailq_from'}</b></td> ",
              "<td><b>$text{'mailq_to'}</b></td> ",
              "<td><b>$text{'mailq_size'}</b></td> ",
	      "<td><b>$text{'mailq_status'}</b></td> </tr>\n";
	foreach $f (@qfiles) {
		($n = $f) =~ s/^.*\///;
		$from = $to = $date = $text{'mailq_unknown'};
		$status = $text{'mailq_sending'};
		open(QFILE, $f) || next;
		while(<QFILE>) {
			if (/^[^\-]*To:\s+(.*)/) { $to = $1; }
			elsif (/^[^\-]*From:\s+(.*)/) { $from = $1; }
			elsif (/^[^\-]*Date:\s+(.*)/) { $date = $1; }
			elsif (/^M(.*)/) { $status = $1; }
			}
		close(QFILE);
		$from =~ s/</&lt;/g; $from =~ s/>/&gt;/g;
		$to =~ s/</&lt;/g; $to =~ s/>/&gt;/g;
		$date =~ s/\+.*//g;
		($d = $f) =~ s/\/qf/\/df/;
		@st = stat($d);
		if ($st[7] > 1000000) {
			$size = int($st[7] / 1000000)." MB";
			}
		elsif ($st[7] > 1000) {
			$size = int($st[7] / 1000)." kB";
			}
		else {
			$size = "$st[7] b";
			}
		print "<tr $cb>\n";
		if ($access{'mailq'} == 2) {
			print "<td><input type=checkbox name=file ",
			      "value=$f></td>\n";
			print "<td><font size=1><a href=\"view_mailq.cgi?",
			      "file=$f\">$n</a></font></td>\n";
			}
		else {
			print "<td><font size=1>$n</font></td>\n";
			}
		print "<td><font size=1>$date</font></td>\n";
		print "<td><font size=1>$from</font></td>\n";
		print "<td><font size=1>$to</font></td>\n";
		print "<td><font size=1>$size</font></td>\n";
		print "<td><font size=1>$status</font></td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	print "<a href='' onClick='for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
	print "<a href='' onClick='for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = !document.forms[0].file[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;<p>\n";
	if ($access{'mailq'} == 2) {
		print "<input type=submit value='$text{'mailq_delete'}'><p>\n";
		print "<hr><p>",$text{'mailq_dmsg'},"<br>\n";
		}
	print &text('mailq_force', 'flushq.cgi'),"<p>\n";
	print "</form>\n";
	}
else {
	print "<b>$text{'mailq_none'}</b> <p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

