#!/usr/local/bin/perl
# edit_passwd.cgi

require './passwd-lib.pl';
&foreign_require("useradmin", "user-lib.pl");
&ReadParse();
&error_setup($text{'passwd_err'});

# Find the user by name or index
@ulist = &foreign_call("useradmin", "list_users");
if (!defined($in{'idx'})) {
	foreach $u (@ulist) {
		if ($u->{'user'} eq $in{'user'}) {
			$user = $u;
			last;
			}
		}
	}
else {
	$user = $ulist[$in{'idx'}];
	}
$user || &error($text{'passwd_euser'});
&can_edit_passwd($user) || &error($text{'passwd_ecannot'});

# Show password change form
&header($text{'passwd_title'}, "");
print "<hr>\n";
print "<form action=save_passwd.cgi>\n";
print "<input type=hidden name=idx value=$user->{'num'}>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'passwd_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'passwd_for'}</b></td>\n";
print "<td>$user->{'user'}",( $user->{'real'} ? " ($user->{'real'})" : "" ),
      "</td> </tr>\n";

if ($access{'old'} == 1 ||
    $access{'old'} == 2 && $user->{'user'} ne $ENV{'REMOTE_USER'}) {
	print "<tr> <td><b>$text{'passwd_old'}</b></td>\n";
	print "<td><input name=old size=25 type=password></td> </tr>\n";
	}

print "<tr> <td><b>$text{'passwd_new'}</b></td>\n";
print "<td><input name=new size=25 type=password></td> </tr>\n";

if ($access{'repeat'}) {
	print "<tr> <td><b>$text{'passwd_repeat'}</b></td>\n";
	print "<td><input name=repeat size=25 type=password></td> </tr>\n";
	}

print "<tr> <td colspan=2>\n";
print "<input type=submit value='$text{'passwd_change'}'>\n";
print "<input type=reset value='$text{'passwd_reset'}'></td> </tr>\n";

print "</table></td></tr></table></form>\n";
print "<hr>\n";
&footer("", $text{'index_return'}) if (defined($in{'idx'}));

