#!/usr/local/bin/perl
# atboot.pl
# Called by setup.sh to have webmin started at boot time

$no_acl_check++;
require './init-lib.pl';
if (!$config{'init_base'}) {
	# Add to the boot time rc script
	open(LOCAL, ">>$config{'local_script'}");
	print LOCAL "$config_directory/start	# Start webmin\n";
	close(LOCAL);
	print "Added to bootup script $config{'local_script'}\n";
	}
else {
	# Create a bootup action
	($initrl) = &get_inittab_runlevel();
	$fn = &action_filename("webmin");
	open(ACTION,">$fn");
	$desc = "Start/stop Webmin";
	print ACTION "#!/bin/sh\n";
	$start_order = "9" x $config{'order_digits'};
	$stop_order = "9" x $config{'order_digits'};
	if ($config{'chkconfig'}) {
		# Redhat-style description: and chkconfig: lines
		print ACTION "# description: $desc\n";
		print ACTION "# chkconfig: $config{'chkconfig'} ",
			     "$start_order $stop_order\n";
		}
	elsif ($config{'init_info'}) {
		# Suse-style init info section
		print ACTION "### BEGIN INIT INFO\n",
			     "# Provides: webmin\n",
			     "# Default-Start: $initrl\n",
			     "# Description: $desc\n",
			     "### END INIT INFO\n";
		}
	else {
		# Just description in a comment
		print "# $desc\n";
		}
	print ACTION "\n";
	print ACTION "case \"\$1\" in\n";

	print ACTION "'start')\n";
	print ACTION "\t$config_directory/start\n";
	print ACTION "\ttouch $config{'subsys'}/webmin\n"
		if ($config{'subsys'});
	print ACTION "\t;;\n";

	print ACTION "'stop')\n";
	print ACTION "\t$config_directory/stop\n";
	print ACTION "\trm -f $config{'subsys'}/webmin\n"
		if ($config{'subsys'});
	print ACTION "\t;;\n";

	print ACTION "'status')\n";
	print ACTION "\tif [ -s /var/webmin/miniserv.pid ]; then\n";
	print ACTION "\t\tpid=`cat /var/webmin/miniserv.pid`\n";
	print ACTION "\t\tkill -0 \$pid >/dev/null 2>&1\n";
	print ACTION "\t\tif [ \"\$?\" = \"0\" ]; then\n";
	print ACTION "\t\t\techo \"webmin (pid \$pid) is running\"\n";
	print ACTION "\t\telse\n";
	print ACTION "\t\t\techo \"webmin is stopped\"\n";
	print ACTION "\t\tfi\n";
	print ACTION "\telse\n";
	print ACTION "\t\techo \"webmin is stopped\"\n";
	print ACTION "\tfi\n";
	print ACTION "\t;;\n";

	print ACTION "'restart')\n";
	print ACTION "\t/etc/webmin/stop && /etc/webmin/start\n";
	print ACTION "\t;;\n";

	print ACTION "*)\n";
	print ACTION "\techo \"Usage: \$0 { start | stop }\"\n";
	print ACTION "\t;;\n";
	print ACTION "esac\n";
	print ACTION "exit 0\n";
	close(ACTION);
	chmod(0755, $fn);
	&add_rl_action("webmin", $initrl, "S", $start_order);
	&add_rl_action("webmin", $initrl, "K", $stop_order);
	print "Created init script $fn\n";
	}

