#!/usr/local/bin/perl
# save_global.cgi
# Save global options

require './fetchmail-lib.pl';
&ReadParse();
&error_setup($text{'global_err'});

&lock_file($in{'file'});
@conf = &parse_config_file($in{'file'});
foreach $c (@conf) {
	$poll = $c if ($c->{'defaults'});
	}
$found++ if ($poll);

# Validate inputs
$in{'port_def'} || $in{'port'} =~ /^\d+$/ ||
	&error($text{'poll_eport'});
if (!$in{'interface_def'}) {
	$in{'interface'} =~ /^\S+$/ || &error($text{'poll_einterface'});
	&check_ipaddress($in{'interface_net'}) || &error($text{'poll_enet'});
	&check_ipaddress($in{'interface_mask'}) || !$in{'interface_mask'} ||
		&error($text{'poll_emask'});
	}

# Create the default structure
$poll->{'defaults'} = 1;
$poll->{'proto'} = $in{'proto'};
$poll->{'port'} = $in{'port_def'} ? undef : $in{'port'};
if ($in{'interface_def'}) {
	delete($poll->{'interface'});
	}
else {
	local @interface = ( $in{'interface'}, $in{'interface_net'} );
	push(@interface, $in{'interface_mask'}) if ($in{'interface_mask'});
	$poll->{'interface'} = join("/", @interface);
	}

if ($found) {
	&modify_poll($poll, $in{'file'});
	}
else {
	&create_poll($poll, $in{'file'});
	if ($in{'user'}) {
		&system_logged("chown $in{'user'} $in{'file'}");
		}
	&system_logged("chmod 700 $in{'file'}");
	}
&unlock_file($in{'file'});
&webmin_log("global", undef, $config{'config_file'} ? $in{'file'} : $in{'user'},
	    \%in);
&redirect("");

