#!/usr/local/bin/perl
# mkfs.cgi
# Where the new filesystem actually gets created.

require './fdisk-lib.pl';
&foreign_require("proc", "proc-lib.pl");
$has_e2label = &has_command("e2label");

&ReadParse();
&can_edit_disk($in{'dev'}) || &error($text{'mkfs_ecannot'});
&error_setup($text{'mkfs_err'});
$cmd = &mkfs_parse($in{type}, $in{dev});
&header($text{'mkfs_title'}, "");
print "<hr>\n";

if (&has_command("e2label") && $in{type} eq 'ext2') {
	chop($label = `e2label $in{dev} 2>/dev/null`);
	}

print &text('mkfs_exec', "<tt>$cmd</tt>"),"<p>\n";
print "<pre>\n";
&foreign_call("proc", "safe_process_exec_logged",
	      $cmd, 0, 0, STDOUT, undef, 1, 1);
print "</pre>\n";

if ($?) { print "<b>$text{'mkfs_failed'}</b> <p>\n"; }
else { print "$text{'mkfs_ok'} <p>\n"; }
if ($label) {
	&system_logged("e2label $in{dev} '$label'");
	}
&webmin_log("mkfs", undef, $in{'dev'}, \%in);

print "<hr>\n";
&footer("", $text{'index_return'});
